/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.base;

import java.awt.Window;
import java.nio.file.Path;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.Action;
import org.freehep.util.FreeHEPLookup;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.gconsole.base.panel.PanelManager;
import org.lsst.ccs.utilities.logging.Logger;

public abstract class Console
extends Subsystem {
    private int statusMessageID = 0;
    private final TreeMap<Integer, String> statusMessageHistory = new TreeMap();
    private final int STATUS_HISTORY_SIZE = 30;

    protected Console() {
        super("CCS-Graphical-Console", AgentInfo.AgentType.CONSOLE);
    }

    public abstract FreeHEPLookup getConsoleLookup();

    public abstract Window getWindow();

    public Logger getLogger() {
        return Logger.getLogger((String)"org.lsst.ccs.ui");
    }

    public abstract Path getHomeDirectory();

    public abstract PanelManager getPanelManager();

    public abstract void error(String var1);

    public abstract void error(String var1, Exception var2);

    public abstract void showInBrowser(String var1);

    public abstract void setStatusMessage(String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int setStatusMessage(String message, int id) {
        TreeMap<Integer, String> treeMap = this.statusMessageHistory;
        synchronized (treeMap) {
            block14: {
                block15: {
                    if (id == 0) {
                        if (message == null) {
                            this.statusMessageHistory.clear();
                            this.statusMessageID = 0;
                            this.setStatusMessage(null);
                            break block14;
                        } else {
                            int n = this.statusMessageID = this.statusMessageHistory.isEmpty() ? 1 : this.statusMessageHistory.lastKey() + 1;
                            if (this.statusMessageID == Integer.MAX_VALUE) {
                                this.statusMessageHistory.clear();
                                this.statusMessageID = 1;
                            }
                            while (true) {
                                if (this.statusMessageHistory.size() <= 30) {
                                    this.statusMessageHistory.put(this.statusMessageID, message);
                                    this.setStatusMessage(message);
                                    return this.statusMessageID;
                                }
                                this.statusMessageHistory.pollFirstEntry();
                            }
                        }
                    }
                    if (id != this.statusMessageID) break block15;
                    if (message == null) {
                        this.statusMessageHistory.remove(id);
                        Map.Entry<Integer, String> e = this.statusMessageHistory.lastEntry();
                        if (e == null) {
                            this.statusMessageID = 0;
                            this.setStatusMessage(null);
                            break block14;
                        } else {
                            this.statusMessageID = e.getKey();
                            this.setStatusMessage(e.getValue());
                        }
                        break block14;
                    } else {
                        this.statusMessageHistory.replace(id, message);
                        this.setStatusMessage(message);
                    }
                    break block14;
                }
                if (message == null) {
                    this.statusMessageHistory.remove(id);
                } else {
                    this.statusMessageHistory.replace(id, message);
                }
            }
            return id;
        }
    }

    public abstract Object addProperty(String var1, Object var2);

    public abstract Object removeProperty(String var1);

    public abstract Object getProperty(String var1);

    public abstract Object setProperty(String var1, Object var2);

    public void setProperties(Map<String, Object> properties) {
        properties.forEach((key, value) -> this.setProperty((String)key, value));
    }

    public abstract void addPropertyListener(PropertyListener var1, String var2);

    public abstract boolean removePropertyListener(PropertyListener var1);

    public abstract void addPreference(String[] var1, String var2, String var3);

    public abstract void addMenu(Action var1, String var2, String ... var3);

    public static interface PropertyListener {
        public void propertiesChanged(Object var1, Map<String, Object> var2);
    }
}

