/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.jas3;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.Point;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import org.freehep.application.mdi.DockPageManager;
import org.freehep.application.mdi.PageContext;
import org.freehep.application.mdi.PageEvent;
import org.freehep.application.mdi.PageListener;
import org.freehep.application.mdi.PageManager;
import org.freehep.application.studio.Studio;
import org.lsst.ccs.gconsole.base.panel.Panel;
import org.lsst.ccs.gconsole.base.panel.PanelEvent;
import org.lsst.ccs.gconsole.base.panel.PanelListener;
import org.lsst.ccs.gconsole.base.panel.PanelManager;
import org.lsst.ccs.gconsole.base.panel.PanelType;

public final class JasPanelManager
implements PanelManager,
PageListener {
    private static final String CONTEXT_KEY = "_context_";
    private final Studio app;
    private final ArrayList<JComponent> panels = new ArrayList();
    private final CopyOnWriteArrayList<FilteredListener> listeners = new CopyOnWriteArrayList();
    private final Object listenersLock = new Object();
    private final Queue<PanelEvent> eventQueue = new LinkedList<PanelEvent>();

    public JasPanelManager(Studio studio) {
        this.app = studio;
    }

    @Override
    public void open(Component panel, Map<?, ?> properties) {
        if (!(panel instanceof JComponent)) {
            throw new IllegalArgumentException("Cannot manage panels that do not subclass JComponent");
        }
        JComponent view = (JComponent)panel;
        if (this.getContext(view) != null) {
            throw new IllegalArgumentException("The panel is already being managed");
        }
        EnumMap<Panel, Object> standardProperties = new EnumMap<Panel, Object>(Panel.class);
        HashMap extraProperties = null;
        if (properties != null) {
            for (Map.Entry<?, ?> e : properties.entrySet()) {
                Object key = e.getKey();
                try {
                    Panel pKey = Panel.getKey(key);
                    standardProperties.put(pKey, e.getValue());
                }
                catch (IllegalArgumentException x) {
                    if (extraProperties == null) {
                        extraProperties = new HashMap();
                    }
                    extraProperties.put(key.toString(), e.getValue());
                }
            }
        }
        PanelType type = standardProperties.getOrDefault(Panel.TYPE, PanelType.DATA);
        PageManager pageMan = this.getPageManager(type);
        PageContext context = pageMan.getContext((Component)view);
        String title = (String)standardProperties.get(Panel.TITLE);
        Icon icon = (Icon)standardProperties.get(Panel.ICON);
        String group = (String)standardProperties.get(Panel.GROUP);
        if (context == null) {
            Boolean selected = standardProperties.getOrDefault(Panel.SELECTED, true);
            if (standardProperties.getOrDefault(Panel.DOCKED, true).booleanValue() || !(pageMan instanceof DockPageManager)) {
                context = pageMan.openPage((Component)view, title, icon, group, selected.booleanValue());
            } else {
                Dimension size = (Dimension)standardProperties.get(Panel.SIZE);
                Point location = (Point)standardProperties.get(Panel.LOCATION);
                String device = (String)standardProperties.get(Panel.DEVICE);
                Boolean maximized = standardProperties.getOrDefault(Panel.MAXIMIZED, false);
                context = ((DockPageManager)pageMan).openPage((Component)view, title, icon, group, selected.booleanValue(), size, location, device, maximized.booleanValue());
            }
        } else {
            if (title != null) {
                context.setTitle(title);
            }
            if (icon != null) {
                context.setIcon(icon);
            }
            if (group != null) {
                context.setType(group);
            }
        }
        context.putProperty((Object)Panel.TYPE, (Object)type);
        if (extraProperties != null) {
            for (Map.Entry e : extraProperties.entrySet()) {
                context.putProperty(e.getKey(), e.getValue());
            }
        }
        view.putClientProperty(CONTEXT_KEY, context);
        this.panels.add(view);
        this.fireEvent(view, Panel.OPEN, false, true);
        context.addPageListener((PageListener)this);
    }

    @Override
    public void close(Component component) {
        PageContext context = this.getContext(component);
        if (context != null) {
            context.close();
        }
    }

    @Override
    public List<JComponent> getPanels() {
        return Collections.unmodifiableList(this.panels);
    }

    @Override
    public Object get(Component component, Object key) {
        PageContext context = this.getContext(component);
        if (context == null) {
            throw new IllegalArgumentException("Not a managed component");
        }
        JComponent panel = (JComponent)context.getPage();
        try {
            Panel pKey = key instanceof Panel ? (Panel)key : Panel.valueOf(key.toString());
            switch (pKey) {
                case GROUP: {
                    return context.type();
                }
                case TITLE: {
                    return context.getTitle();
                }
                case ICON: {
                    return context.getIcon();
                }
                case OPEN: {
                    return true;
                }
                case SELECTED: {
                    PageManager pm = this.getPageManager((PanelType)context.getProperty((Object)Panel.TYPE));
                    try {
                        return pm.getSelectedPage() == context;
                    }
                    catch (Exception x) {
                        return false;
                    }
                }
                case ICONIZED: {
                    for (Container c = panel.getParent(); c != null; c = c.getParent()) {
                        if (c instanceof Frame) {
                            return (((Frame)c).getExtendedState() & 1) > 0;
                        }
                        if (!(c instanceof JInternalFrame)) continue;
                        return ((JInternalFrame)c).isIcon();
                    }
                    return false;
                }
                case DOCKED: {
                    PageManager pm = this.getPageManager((PanelType)context.getProperty((Object)Panel.TYPE));
                    return pm instanceof DockPageManager ? ((DockPageManager)pm).isDocked((Component)panel) : true;
                }
                case SIZE: {
                    return component.getSize();
                }
                case LOCATION: {
                    for (Container c = panel; c != null; c = c.getParent()) {
                        if (c == this.app) {
                            return null;
                        }
                        if (!(c instanceof Window) && !(c instanceof JInternalFrame)) continue;
                        return c.getLocation();
                    }
                    return null;
                }
                case DEVICE: {
                    GraphicsConfiguration gc = panel.getGraphicsConfiguration();
                    return gc == null ? null : gc.getDevice().getIDstring();
                }
                case MAXIMIZED: {
                    for (Container c = panel.getParent(); c != null; c = c.getParent()) {
                        if (c == this.app) {
                            return false;
                        }
                        if (c instanceof Frame) {
                            return (~((Frame)c).getExtendedState() & 6) == 0;
                        }
                        if (!(c instanceof JInternalFrame)) continue;
                        return ((JInternalFrame)c).isMaximum();
                    }
                    return false;
                }
            }
            return context.getProperty((Object)pKey);
        }
        catch (IllegalArgumentException x) {
            return context.getProperty((Object)key.toString());
        }
    }

    @Override
    public boolean isInState(Component panel, Map<?, ?> properties) {
        for (Map.Entry<?, ?> e : properties.entrySet()) {
            if (Objects.equals(e.getValue(), this.get(panel, e.getKey()))) continue;
            return false;
        }
        return true;
    }

    @Override
    public JComponent getPanel(Component component) {
        PageContext context = this.getContext(component);
        return context == null ? null : (JComponent)context.getPage();
    }

    @Override
    public void set(Component component, Object key, Object value) {
        block11: {
            PageContext context = this.getContext(component);
            if (context == null) {
                throw new IllegalArgumentException("Not a managed component");
            }
            JComponent panel = (JComponent)context.getPage();
            try {
                Panel pKey = key instanceof Panel ? (Panel)key : Panel.valueOf(key.toString());
                pKey.checkValue(value);
                switch (pKey) {
                    case GROUP: {
                        context.setType(value.toString());
                        break;
                    }
                    case TITLE: {
                        context.setTitle(value.toString());
                        break;
                    }
                    case ICON: {
                        context.setIcon((Icon)value);
                        break;
                    }
                    case SELECTED: {
                        if (((Boolean)value).booleanValue()) {
                            context.requestShow();
                        }
                        break;
                    }
                    case LAST_DESELECTED: {
                        context.putProperty((Object)Panel.LAST_DESELECTED, (Object)((Long)value));
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Immutable property");
                    }
                }
            }
            catch (IllegalArgumentException x) {
                Object oldValue = context.putProperty(key, value);
                if (Objects.equals(oldValue, value)) break block11;
                this.fireEvent(panel, key, oldValue, value);
            }
        }
    }

    public void pageChanged(PageEvent pe) {
        PageContext context = pe.getPageContext();
        if (context == null) {
            return;
        }
        JComponent panel = (JComponent)context.getPage();
        if (panel == null || context != panel.getClientProperty(CONTEXT_KEY)) {
            return;
        }
        switch (pe.getID()) {
            case 4004: {
                break;
            }
            case 4001: {
                context.removePageListener((PageListener)this);
                Iterator<JComponent> it = this.panels.iterator();
                while (it.hasNext()) {
                    if (it.next() != panel) continue;
                    it.remove();
                    break;
                }
                this.fireEvent(panel, Panel.OPEN, true, false);
                this.removeListeners(panel);
                panel.putClientProperty(CONTEXT_KEY, null);
                break;
            }
            case 4002: {
                this.fireEvent(panel, Panel.ICONIZED, false, true);
                break;
            }
            case 4003: {
                this.fireEvent(panel, Panel.ICONIZED, true, false);
                break;
            }
            case 3999: {
                List<Component> groupPanels;
                this.fireEvent(panel, Panel.SELECTED, false, true);
                String group = (String)this.get((Component)panel, Panel.GROUP);
                if (group == null || (groupPanels = this.getPanels(Panel.GROUP, group)).size() <= 1) break;
                EnumSet<PanelType> alreadySelected = EnumSet.noneOf(PanelType.class);
                List<Component> selectedPanels = this.getPanels(Panel.SELECTED, true);
                for (Component c : selectedPanels) {
                    String g = (String)this.get(c, Panel.GROUP);
                    if (!group.equals(g)) continue;
                    alreadySelected.add((PanelType)this.get(c, Panel.TYPE));
                }
                EnumMap<PanelType, Component> toSelect = new EnumMap<PanelType, Component>(PanelType.class);
                for (Component p2 : groupPanels) {
                    long ppTime;
                    long pTime;
                    PanelType type;
                    if (p2 == panel || alreadySelected.contains(type = (PanelType)this.get(p2, Panel.TYPE))) continue;
                    Component pp = (Component)toSelect.get(type);
                    if (pp != null && (pTime = ((Long)this.getOrDefault(p2, Panel.LAST_DESELECTED, 0L)).longValue()) > (ppTime = ((Long)this.getOrDefault(pp, Panel.LAST_DESELECTED, 0L)).longValue())) {
                        pp = null;
                    }
                    if (pp != null) continue;
                    toSelect.put(type, p2);
                }
                toSelect.values().forEach(p -> this.set((Component)p, Panel.SELECTED, true));
                break;
            }
            case 4000: {
                context.putProperty((Object)Panel.LAST_DESELECTED, (Object)System.currentTimeMillis());
                this.fireEvent(panel, Panel.SELECTED, true, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(PanelListener listener) {
        Object object = this.listenersLock;
        synchronized (object) {
            this.listeners.removeIf(fl -> fl.listener == listener && fl.panel != null);
            if (this.listeners.stream().noneMatch(fl -> fl.listener == listener)) {
                this.listeners.add(new FilteredListener(listener));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(PanelListener listener, Component component) {
        JComponent panel = this.getPanel(component);
        if (panel == null) {
            throw new IllegalArgumentException("Attempt to manage listeners of a non-existing panel");
        }
        Object object = this.listenersLock;
        synchronized (object) {
            if (this.listeners.stream().noneMatch(fl -> fl.listener == listener && (fl.panel == null || fl.panel == panel))) {
                this.listeners.add(new FilteredListener(listener, panel));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(PanelListener listener) {
        Object object = this.listenersLock;
        synchronized (object) {
            this.listeners.removeIf(fl -> fl.listener == listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(PanelListener listener, Component component) {
        JComponent panel = this.getPanel(component);
        if (panel == null) {
            throw new IllegalArgumentException("Attempt to manage listeners of a non-existing panel");
        }
        Object object = this.listenersLock;
        synchronized (object) {
            this.listeners.removeIf(fl -> fl.listener == listener && fl.panel == panel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeListeners(JComponent panel) {
        Object object = this.listenersLock;
        synchronized (object) {
            this.listeners.removeIf(fl -> fl.panel == panel);
        }
    }

    private void fireEvent(JComponent panel, Object key, Object oldValue, Object newValue) {
        PanelEvent event = new PanelEvent(panel, key, oldValue, newValue);
        if (this.eventQueue.isEmpty()) {
            while (event != null) {
                for (FilteredListener fl : this.listeners) {
                    if (fl.panel != null && fl.panel != panel) continue;
                    fl.listener.process(event);
                }
                event = this.eventQueue.poll();
            }
        } else {
            this.eventQueue.add(event);
        }
    }

    public PageManager getPageManager(PanelType type) {
        switch (type) {
            case DATA: {
                return this.app.getPageManager();
            }
            case CONTROL: {
                return this.app.getControlManager();
            }
            case CONSOLE: {
                return this.app.getConsoleManager();
            }
        }
        throw new IllegalArgumentException("Cannot find page manager for panel of type " + type);
    }

    public PageContext findPage(PanelType type, String title) {
        PageManager pm = this.getPageManager(type);
        for (PageContext context : pm.pages()) {
            if (!title.equals(context.getTitle())) continue;
            return context;
        }
        return null;
    }

    public PageContext getContext(Component component) {
        while (component != null) {
            Object o;
            Object object = o = component instanceof JComponent ? ((JComponent)component).getClientProperty(CONTEXT_KEY) : null;
            if (o != null && o instanceof PageContext) {
                return (PageContext)o;
            }
            component = component.getParent();
        }
        return null;
    }

    private static class FilteredListener {
        final PanelListener listener;
        final JComponent panel;

        FilteredListener(PanelListener listener) {
            this(listener, null);
        }

        FilteredListener(PanelListener listener, JComponent panel) {
            this.listener = listener;
            this.panel = panel;
        }
    }
}

