/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.base.panel;

import java.awt.Component;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import org.lsst.ccs.gconsole.base.panel.Panel;
import org.lsst.ccs.gconsole.base.panel.PanelListener;

public interface PanelManager {
    public void open(Component var1, Map<?, ?> var2);

    default public void open(Component panel, String title) {
        this.open(panel, Collections.singletonMap(Panel.TITLE, title));
    }

    public void close(Component var1);

    default public void close(Predicate<Component> selector) {
        this.getPanels(selector).forEach(panel -> this.close((Component)panel));
    }

    default public void close(Map<?, ?> properties) {
        this.getPanels(properties).forEach(panel -> this.close((Component)panel));
    }

    public List<JComponent> getPanels();

    default public List<Component> getPanels(Predicate<Component> selector) {
        return this.getPanels().stream().filter(selector).collect(Collectors.toList());
    }

    default public List<Component> getPanels(Map<?, ?> properties) {
        return this.getPanels((Component panel) -> this.isInState((Component)panel, properties));
    }

    default public List<Component> getPanels(Object key, Object value) {
        return this.getPanels(Collections.singletonMap(key, value));
    }

    public Object get(Component var1, Object var2);

    default public Object getOrDefault(Component panel, Object key, Object defaultValue) {
        Object value = this.get(panel, key);
        return value == null ? defaultValue : value;
    }

    default public HashMap<String, Serializable> get(Component panel, Collection<?> keys) {
        HashMap<String, Serializable> out = new HashMap<String, Serializable>(keys.size() * 2);
        keys.forEach(key -> {
            Object value = this.get(panel, key);
            if (value instanceof Serializable) {
                out.put(key.toString(), (Serializable)value);
            }
        });
        return out;
    }

    public boolean isInState(Component var1, Map<?, ?> var2);

    public Component getPanel(Component var1);

    public void set(Component var1, Object var2, Object var3);

    public void addListener(PanelListener var1);

    public void addListener(PanelListener var1, Component var2);

    public void removeListener(PanelListener var1);

    public void removeListener(PanelListener var1, Component var2);
}

