/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.localdb.statusdb.model;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.boot.model.naming.ImplicitEntityNameSource;
import org.hibernate.boot.model.naming.ImplicitForeignKeyNameSource;
import org.hibernate.boot.model.naming.ImplicitIndexNameSource;
import org.hibernate.boot.model.naming.ImplicitJoinColumnNameSource;
import org.hibernate.boot.model.naming.ImplicitJoinTableNameSource;
import org.hibernate.boot.model.naming.ImplicitNamingStrategyJpaCompliantImpl;
import org.hibernate.boot.model.naming.ImplicitUniqueKeyNameSource;

public class CCSNamingStrategy
extends ImplicitNamingStrategyJpaCompliantImpl {
    private static final long serialVersionUID = 3751202026782556556L;
    private static final String CCS_PREFIX = "ccs_";
    private List<String> uniqueNames = new ArrayList<String>();

    public Identifier determinePrimaryTableName(ImplicitEntityNameSource source) {
        String tableName = source.getEntityNaming().getJpaEntityName();
        tableName = Character.toLowerCase(tableName.charAt(0)) + tableName.substring(1);
        return this.checkIdentifier(new Identifier(CCS_PREFIX + tableName, false));
    }

    public Identifier determineForeignKeyName(ImplicitForeignKeyNameSource source) {
        return this.checkIdentifier(new Identifier(CCS_PREFIX + CCSNamingStrategy.shortName(source.getTableName().getText()) + "_" + CCSNamingStrategy.shortColumnsIdentifier(source.getColumnNames()) + "_" + CCSNamingStrategy.shortName(source.getReferencedTableName().getText()) + "_fk", false));
    }

    public Identifier determineUniqueKeyName(ImplicitUniqueKeyNameSource source) {
        return this.checkIdentifier(new Identifier(CCS_PREFIX + CCSNamingStrategy.shortName(source.getTableName().getText()) + "_" + CCSNamingStrategy.shortColumnsIdentifier(source.getColumnNames()) + "_u", false));
    }

    public Identifier determineIndexName(ImplicitIndexNameSource source) {
        return this.checkIdentifier(new Identifier(CCS_PREFIX + CCSNamingStrategy.shortName(source.getTableName().getText()) + "_" + CCSNamingStrategy.shortColumnsIdentifier(source.getColumnNames()) + "_i", false), false);
    }

    public Identifier determineJoinTableName(ImplicitJoinTableNameSource source) {
        return this.checkIdentifier(new Identifier(CCS_PREFIX + CCSNamingStrategy.shortName(source.getOwningPhysicalTableName()) + "_" + CCSNamingStrategy.shortName(source.getNonOwningPhysicalTableName()) + "_b", false), false);
    }

    public Identifier determineJoinColumnName(ImplicitJoinColumnNameSource source) {
        String columnName = super.determineJoinColumnName(source).getText();
        if (columnName.endsWith("_id")) {
            columnName = columnName.substring(0, columnName.length() - 3) + "Id";
        }
        columnName = Character.toLowerCase(columnName.charAt(0)) + columnName.substring(1);
        return new Identifier(columnName, false);
    }

    private static String shortColumnsIdentifier(List<Identifier> cols) {
        String result = "";
        for (Identifier col : cols) {
            if (!result.isEmpty()) {
                result = result + "_";
            }
            result = result + CCSNamingStrategy.shortName(col.getText());
        }
        return result;
    }

    protected static String shortName(String tableName) {
        String result = "";
        tableName = tableName.replace(CCS_PREFIX, "");
        boolean add = false;
        boolean nChars = true;
        int counter = 0;
        boolean check = true;
        for (int i = 0; i < tableName.length(); ++i) {
            char c = tableName.charAt(i);
            if (i == 0) {
                result = result + Character.toLowerCase(c);
                add = true;
                check = false;
            } else if (Character.isUpperCase(c)) {
                result = result + c;
                counter = 0;
                add = true;
                check = true;
            } else if (add) {
                result = result + c;
                ++counter;
            }
            if (counter != nChars || !check) continue;
            add = false;
            counter = 0;
        }
        if (result.endsWith("_b")) {
            result = result.replace("_b", "");
        }
        return result;
    }

    private Identifier checkIdentifier(Identifier id) {
        return this.checkIdentifier(id, true);
    }

    private Identifier checkIdentifier(Identifier id, boolean checkUnique) {
        if (!this.uniqueNames.contains(id.getText())) {
            this.uniqueNames.add(id.getText());
        } else if (checkUnique) {
            throw new RuntimeException("ERROR: generated name " + id.getText() + " already exists.");
        }
        if (id.getText().length() > 64) {
            throw new RuntimeException("ERROR: name exceeds maximum length of 64 chars " + id.getText());
        }
        return id;
    }
}

