/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.dictionary;

import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import org.freehep.application.Application;
import org.freehep.application.studio.Studio;
import org.lsst.ccs.gconsole.Plugin;
import org.lsst.ccs.gconsole.base.ConsolePlugin;
import org.lsst.ccs.gconsole.plugins.dictionary.DictionaryBusMaster;
import org.lsst.ccs.messaging.AgentMessagingLayer;

@Plugin(name="LSST Dictionary Plugin", description="LSST Dictionary Plugin allows listing available commands for a subsystem and executing them.", shortDescription="LSST CCS Dictionary GUI")
public class LsstDictionaryPlugin
extends ConsolePlugin {
    private final String defaultConsoleName = "Dictionary Interface";
    DictionaryBusMaster dictionaryBusMaster;
    private AgentMessagingLayer messagingAccess;

    @Override
    public void initialize() {
        AbstractAction newDictionaryAction = new AbstractAction("Dictionary"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LsstDictionaryPlugin.this.createDictionaryDialog("Dictionary Interface");
            }
        };
        this.getServices().addMenu(newDictionaryAction, "400: CCS Tools :-1:5");
    }

    @Override
    public void start() {
        this.messagingAccess = this.getConsole().getMessagingAccess();
    }

    private void createDictionaryDialog(String name) {
        this.dictionaryBusMaster = new DictionaryBusMaster(this.messagingAccess);
        this.dictionaryBusMaster.initGUI();
        Studio studio = (Studio)Application.getApplication();
        studio.getPageManager().openPage((Component)this.dictionaryBusMaster.getMainPane(), name, null);
        studio.getPageManager().addPageListener(event -> {
            Component c;
            if (event.getID() == 4001 && (c = event.getPageContext().getPage()).equals(this.dictionaryBusMaster.getMainPane())) {
                this.dictionaryBusMaster.doShutdown();
            }
        });
    }
}

