package org.lsst.ccs.gconsole.plugins.trending;

import java.io.Serializable;

/**
 * Trending channel identifier.
 * The channel contains a unique path used for placement in the tree of channels, 
 * and a title used for naming plots. Channel equality and comparisons are based
 * on their paths.
 *
 * @author onoprien
 */
public class TrendingChannel implements Serializable, Comparable<TrendingChannel> {

// -- Fields : -----------------------------------------------------------------
    
    private final String path;
    private final String title;

// -- Life cycle : -------------------------------------------------------------
    
    /**
     * Constructs a channel with a title equal to the path.
     * @param path The path used for placement in the tree of channels.
     */
    public TrendingChannel(String path) {
        this(path, null);
    }
    
    /**
     * Constructs a channel.
     * @param path The path used for placement in the tree of channels.
     * @param title The title used for naming.
     */
    public TrendingChannel(String path, String title) {
        this.path = path;
        this.title = title;
    }
    
    
// -- Getters : ----------------------------------------------------------------

    /**
     * Returns the slash-separated path to this channel in the tree of channels displayed by the trending tool.
     * @return The path used for placement in the tree of channels.
     */
    public String getPath() {
        return path;
    }

    /**
     * Returns the title of this channel used for naming and identifying plots.
     * @return The title of this channel. 
     */
    public String getTitle() {
        return title == null ? path : title;
    }

// -- Overriding Object : ------------------------------------------------------
    
    @Override
    public int hashCode() {
        return path.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof TrendingChannel) {
            return path.equals(((TrendingChannel)obj).path);
        } else {
            return false;
        }
    }

    @Override
    public String toString() {
        return path;
    }

    @Override
    public int compareTo(TrendingChannel other) {
        return path.compareTo(other.path);
    }
}
