package org.lsst.ccs.gconsole.plugins.elog;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.freehep.application.Application;
import org.freehep.application.studio.Studio;
import org.lsst.ccs.gconsole.base.ConsolePlugin;

/**
 * This plugin deals with creating postings to the LSST CCS ELog.
 * @author tonyj
 */
@org.lsst.ccs.gconsole.Plugin(name="LSST ELog Plugin",
        description="LSST ELog plugin.")
public class LsstELogPlugin extends ConsolePlugin {

    private final Studio studio = (Studio) Application.getApplication();

    @Override
    public void initialize() {

        Action act = new AbstractAction("ELog") {
            @Override
            public void actionPerformed(ActionEvent e) {
                createELogDialog();
            }
        };
        getServices().addMenu(act, "400: CCS Tools :-1:6");
    }

    private void createELogDialog() {        
        studio.getPageManager().openPage(new LsstElogSubmissionDialog(), "LSST CCS Elog", null);
    }

}
