/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.monitor;

import java.lang.reflect.Constructor;
import java.util.BitSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.framework.Configurable;
import org.lsst.ccs.framework.ConfigurableComponent;
import org.lsst.ccs.subsystem.monitor.Control;
import org.lsst.ccs.subsystem.monitor.Monitor;
import org.lsst.ccs.utilities.logging.Logger;

public abstract class Device
extends ConfigurableComponent {
    protected String fullName;
    protected BitSet chanMask;
    protected boolean disabled;
    protected boolean inited;
    protected boolean online;
    protected Monitor mon;
    protected Logger log;
    protected Map<String, Control> ctlChans;
    protected int lineMask;
    protected int lineWarm;
    protected int lineState;

    public String getFullName() {
        return this.fullName;
    }

    public boolean isOnline() {
        return this.online;
    }

    public void disable() {
        this.disabled = true;
        this.setOnline(false);
    }

    public void enable() {
        this.disabled = false;
        this.checkOnline();
    }

    protected void configure(Monitor mon) {
        this.mon = mon;
        this.log = mon.log;
        this.chanMask = new BitSet(mon.getNumChans());
        Configurable.Environment ce = this.getEnvironment();
        if (ce != null) {
            this.ctlChans = this.getChildren(Control.class);
            for (Control ctl : this.ctlChans.values()) {
                ctl.configure(mon, this);
            }
        } else {
            this.ctlChans = new HashMap<String, Control>();
        }
    }

    @Command(type=Command.CommandType.QUERY, description="Gets map of configured items")
    public Map<String, Object> getConfigValues() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        this.addConfigValues(map);
        for (Control ctl : this.ctlChans.values()) {
            ctl.addConfigValues(map);
        }
        return map;
    }

    protected int[] checkChannel(String name, int hwChan, String type, String subtype) throws Exception {
        return new int[]{0, 0};
    }

    protected abstract void initialize();

    protected abstract void close();

    protected void initSensors() {
        int id = this.chanMask.nextSetBit(0);
        while (id >= 0) {
            this.mon.getChannel(id).initSensor();
            id = this.chanMask.nextSetBit(id + 1);
        }
    }

    protected void initChannel(int hwChan, int type, int subtype) {
    }

    protected void initChannel(String name, int id, int hwChan, int type, int subtype) {
        this.initChannel(hwChan, type, subtype);
    }

    protected void addChannel(int id) {
        this.chanMask.set(id);
    }

    protected void dropChannel(int id) {
        this.chanMask.clear(id);
        BitSet mask = new BitSet(id);
        mask.set(id);
        this.mon.setOnline(mask, false);
        this.mon.getChannel(id).setValid(false);
    }

    public void checkOnline() {
        if (this.online || this.disabled) {
            return;
        }
        this.initialize();
    }

    protected boolean testOnline() {
        if (!this.online) {
            this.log.error((Object)("Device " + this.fullName + " is offline"));
        }
        return this.online;
    }

    protected void setOnline(boolean online) {
        if (this.online == online) {
            return;
        }
        this.online = online;
        this.mon.setOnline(this.chanMask, online);
        if (!online) {
            if (!this.disabled) {
                this.log.error((Object)("Disconnected from " + this.fullName));
            }
            this.close();
        }
    }

    protected void readSensors() {
        this.readChannelGroup();
        int id = this.chanMask.nextSetBit(0);
        while (id >= 0) {
            this.mon.getChannel(id).readSensor();
            id = this.chanMask.nextSetBit(id + 1);
        }
    }

    protected void readChannelGroup() {
    }

    protected double readChannel(int hwChan, int type) {
        return Double.NaN;
    }

    protected double readChannelNow(int hwChan, int type) {
        return this.readChannel(hwChan, type);
    }

    protected void addConfigValues(Map<String, Object> map) {
    }

    protected void checkTimeout(Exception e, Class<?> eClass) throws Exception {
        if (this.isTimeout(e)) {
            this.setOnline(false);
        }
        Constructor<?> eCon = eClass.getConstructor(String.class);
        throw (Exception)eCon.newInstance(e.getMessage());
    }

    protected boolean isTimeout(Exception e) {
        return e.getMessage().matches(".*time.*out.*");
    }

    protected void checkLine(String name, int line) throws Exception {
        this.checkHwLine(name, line);
    }

    protected void checkHwLine(String name, int line) throws Exception {
        this.mon.reportError(name, "device", this.getName());
    }

    protected void setLineWarm(int line, boolean on) {
        this.lineWarm = on ? (this.lineWarm |= 1 << line) : (this.lineWarm &= ~(1 << line));
    }

    protected void setLine(int line, boolean on) {
        this.lineState = on ? (this.lineState |= 1 << line) : (this.lineState &= ~(1 << line));
        this.setHwLine(line, on);
    }

    protected void setHwLine(int line, boolean on) {
    }

    protected boolean isLineSet(int line) {
        return this.isHwLineSet(line);
    }

    protected boolean isHwLineSet(int line) {
        return false;
    }

    protected void setOutputLines() {
        int mask = this.lineMask;
        int line = 0;
        while (mask != 0) {
            if ((mask & 1) != 0) {
                if ((this.lineWarm & 1 << line) == 0) {
                    this.setLine(line, (this.lineState & 1 << line) != 0);
                } else {
                    this.setLine(line, this.isHwLineSet(line));
                }
            }
            mask >>>= 1;
            ++line;
        }
    }

    protected void getOutputLines() {
        this.lineState = 0;
        int mask = this.lineMask;
        int line = 0;
        while (mask != 0) {
            if ((mask & 1) != 0) {
                this.lineState |= this.isHwLineSet(line) ? 1 << line : 0;
            }
            mask >>>= 1;
            ++line;
        }
    }

    protected void addLine(int line) {
        this.lineMask |= 1 << line;
    }
}

