package org.lsst.ccs.gconsole.plugins.dictionary;

import java.awt.Font;
import java.io.IOException;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import org.lsst.ccs.utilities.logging.Logger;

/**
 *
 * @author emarin
 */
public class HTMLTextPane extends JTextPane {

    private static final int MAX_LENGTH = 10000;
    HTMLEditorKit kit;
    HTMLDocument doc;
    private final Logger log = Logger.getLogger("org.lsst.ccs.plugin.jas3.dictionary");
    
    public HTMLTextPane() {
        setEditable(false);
        kit = new HTMLEditorKit();
        doc = new HTMLDocument();
        this.setEditorKit(kit);
        
        // Font management
        Font font = new Font(Font.MONOSPACED, Font.PLAIN, 15);
        String bodyrule = "body { font-family: " + font.getFamily() + "; " + 
                "font-size: " + font.getSize() + "pt;}";
        doc.getStyleSheet().addRule(bodyrule);

        this.setDocument(doc);
    }
    
    public void insertHTML(String s){
        try {
            kit.insertHTML(doc, doc.getLength(), s, 0, 0, null);
            int overLength=doc.getLength() - MAX_LENGTH;
            if (overLength > 0){
                removeOverLength(overLength);
            }
        } catch (BadLocationException ex) {
            log.error(ex);
        } catch (IOException ex) {
            log.error(ex);
        }
    }
    
    private void removeOverLength(int overLength) throws BadLocationException{
                doc.remove(0,overLength);
    }
    
}
