package org.lsst.ccs.gconsole.plugins.dictionary;

import java.util.ArrayList;
import java.util.List;
import javax.swing.table.DefaultTableModel;
import org.lsst.ccs.bus.data.AgentInfo;

/**
 *
 * @author emarin
 */
public class AgentDefaultTableModel extends DefaultTableModel {

    public AgentDefaultTableModel(Object[] colNames, int rowCount){
        super(colNames,rowCount);
    }
    
    public AgentDefaultTableModel(Object[][] data, Object[] colNames){
        super(data,colNames);
    }
    
//    // Needed by the renderer
//    @Override 
//    public Class getColumnClass(int c){
//            return getValueAt(0, c).getClass();
//    }
    
    public void update(Object[][] data){
        Object[][] currentTab = new Object[getDataVector().size()][1];
        for (int i = 0; i<getDataVector().size();i++){
            currentTab[i][0]=getValueAt(i, 0);
        }
        
        // To be removed
        List toBeRemoved = new ArrayList();
        for (int i=0;i<currentTab.length;i++){
            boolean found = false;
            for (int j=0;i<data.length;j++){
                // equals is overriden in Agent
                if (data[j][0].equals(data[i][0])){
                    found = true;
                    break;
                }
            }
            if (!found){
                removeRow((AgentInfo)currentTab[i][0]);
                //toBeRemoved.add(currentTab[i]);
            }
        }
        
        // Search for the ones to be added
        List toBeAdded = new ArrayList();
        for (int i=0;i<data.length;i++){
            boolean found=false;
            for (int j=0;j<currentTab.length;j++){
                if (currentTab[j][0].equals(data[i][0])){
                    found=true;
                    break;
                }
            }
            if (!found){
                addRow(data[i]);
            }
        }
//        
//        setRowCount(0);
//        for(int i=0;i<data.length;i++){
//            addRow(data[i]);
//        }
    }
    
    @Override
    public boolean isCellEditable(int row, int col){
    //    return false;
        return (col==0)?false:true;
    }
    
    public void removeRow(AgentInfo agent){
        for (int i=0;i<getRowCount();i++){
            if (agent.equals(getValueAt(i, 0))){
                removeRow(i);
                return;
            }
        }
    }
}
