package org.lsst.ccs.gconsole.base;

import java.io.Serializable;

/**
 * JavaBean that contains information on a graphical console component.
 *
 * @author onoprien
 */
public class ComponentDescriptor implements Serializable {

// -- Fields : -----------------------------------------------------------------
    
    private String name = "";
    private String version;
    private String description;
    private String shortDescription;
    private String className;
    private ComponentDescriptor configuration;
    
// -- Constructors : -----------------------------------------------------------
    
    public ComponentDescriptor() {
    }
    
    public ComponentDescriptor(ComponentDescriptor other) {
        name = other.name;
        version = other.version;
        description = other.description;
        shortDescription = other.shortDescription;
        className = other.className;
    }

// -- Getters & Setters: -------------------------------------------------------

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getVersion() {
        return version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getShortDescription() {
        return shortDescription == null ? description : shortDescription;
    }

    public void setShortDescription(String shortDescription) {
        this.shortDescription = shortDescription;
    }

    public String getClassName() {
        return className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public ComponentDescriptor getConfiguration() {
        return configuration;
    }

    public void setConfiguration(ComponentDescriptor configuration) {
        this.configuration = configuration;
    }
}
