package org.lsst.ccs.gconsole.plugins.plots;

import java.io.IOException;
import org.lsst.ccs.bus.messages.StatusSubsystemData;
import org.lsst.ccs.gconsole.jas3.LsstPlugin;
import org.lsst.ccs.messaging.BusMessageFilter;
import org.xml.sax.SAXException;

/**
 * This plugin deals with creating LSST CCS plots published on the Status bus.
 * @author turri
 */
public class LsstPlotsPlugin extends LsstPlugin {

    @Override
    public void init() throws SAXException, IOException {
        getApplication().getLookup().add(this);
        
    }
    
    @Override
    protected void postInit(){
        getMessagingAccess().addStatusMessageListener(new PlotsListener(getApplication()), BusMessageFilter.messageClass(StatusSubsystemData.class));
    }

}
