package org.lsst.ccs.gconsole;

import java.awt.Container;
import java.io.Serializable;
import java.util.*;
import javax.swing.JComponent;

/**
 * A panel displayed by the graphical console.
 * Panels can contain plot pages, control panels, subsystem GUIs, etc.
 *
 * @author onoprien
 */
public class Panel {

// -- Fields : -----------------------------------------------------------------
    
    static private final String PANEL_KEY_IN_VIEW = "GraphConsolePanel";
    
    private PanelManager panMan;
    private JComponent view;
    private final HashMap<String,Serializable> state = new HashMap<>();

// -- Life cycle : -------------------------------------------------------------
    
    public Panel() {
    }
    
    public Panel(JComponent view) {
        this.view = view;
    }

// -- Setters and Getters : ----------------------------------------------------
    
    static public Panel getPanel(JComponent component) {
        while (component != null) {
            Object o = component.getClientProperty(PANEL_KEY_IN_VIEW);
            if (o != null && o instanceof Panel) {
                return (Panel) o;
            } else {
                Container parent = component.getParent();
                component = parent instanceof JComponent ? (JComponent)parent : null;
            }
        }
        return null;
    }

    public PanelManager getPanelManager() {
        return panMan;
    }
    
    public void setPanelManager(PanelManager panMan) {
        this.panMan = panMan;
    }

    public JComponent getView() {
        return view;
    }

    public void setView(JComponent view) {
        view.putClientProperty(PANEL_KEY_IN_VIEW, this);
        this.view = view;
    }
    
    public Map<String,Serializable> getState() {
        return state;
    }
    
    public Serializable set(String key, Serializable value) {
        return state.put(key, value);
    }

}
