package org.lsst.ccs.gconsole.plugins.dictionary;

import java.awt.Color;
import java.awt.Component;
import java.util.concurrent.ExecutionException;
import javax.swing.JTree;
import javax.swing.SwingWorker;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import org.lsst.ccs.utilities.structs.TreeBranch;

/**
 *
 * @author emarin
 */
public class DictionaryTreePanel extends JTree {

       private CommandListener commandListener;
       private TreeBranch<DictionaryContext> dictionaryTree;
       private CommandTreeRenderer renderer;


    DictionaryTreePanel(CommandListener cmdListener) {
        super();
        this.setModel(new DefaultTreeModel(dictionaryTree));
       
        this.commandListener = cmdListener;
        getSelectionModel().setSelectionMode(TreeSelectionModel.SINGLE_TREE_SELECTION);
        
        renderer = new CommandTreeRenderer(false);
        setCellRenderer(renderer);
    }

    public void updateData(String selectedSubsystem){
        new BuildDictionaryWorker(selectedSubsystem).execute();
    }
    
    public void updateRenderer(boolean isEM){
        renderer.setEM(isEM);
        this.revalidate();
        this.repaint();
    }
    
    private class BuildDictionaryWorker extends SwingWorker<TreeBranch<DictionaryContext>, String> {

        private String destination;

        BuildDictionaryWorker(String destination) {
            this.destination = destination;
        }

        @Override
        protected TreeBranch<DictionaryContext> doInBackground() throws Exception {
            return commandListener.buildDictionaryTree(destination);
        }

        @Override
        public void done() {
            try {
                dictionaryTree = get();
                if (dictionaryTree != null){
                    setModel(new DefaultTreeModel(dictionaryTree));
                    getSelectionModel().setSelectionPath(new TreePath(getModel().getRoot()));
                }
               // revalidate();
                //repaint();
                
            } catch (InterruptedException | ExecutionException ex) {
            }
        }

    }
    
    private class CommandTreeRenderer extends DefaultTreeCellRenderer{
        boolean isEM;

        CommandTreeRenderer(boolean isEM) {
            super();
            this.isEM = isEM;
        }
        
        void setEM(boolean isEM){
            this.isEM = isEM;
        }
        
        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            if(!isEM){
                if ((TreeBranch<DictionaryContext>)value == getModel().getRoot()){
                    setForeground(Color.BLACK);
                }
                else {
                    setForeground(Color.GRAY);
                }
            }
            else {
                setForeground(Color.BLACK);
            }
            return this;
        }
    }
    
}