package org.lsst.ccs.gconsole;

import java.awt.Panel;
import java.io.Serializable;
import java.util.*;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Predicate;
import javax.swing.JComponent;

/**
 *
 * @author onoprien
 */
abstract public class PanelManager {

// -- Fields : -----------------------------------------------------------------
    
    private final CopyOnWriteArrayList<PanelListener> listeners = new CopyOnWriteArrayList();

// -- Life cycle : -------------------------------------------------------------

// -- Operations : -------------------------------------------------------------
    
    abstract public Panel open(JComponent view, Map<String,Serializable> state);
    
    abstract public Panel open(JComponent view, Panel panel);
    
    abstract public boolean close(Panel panel);
    
    public boolean close(Predicate<Panel> selector) {
        boolean closedAll = true;
        for (Panel panel : getPanels(selector)) {
            closedAll = close(panel) && closedAll;
        }
        return closedAll;
    }
    
    abstract public Serializable set(Panel panel, String key, Serializable value);
    
    abstract public boolean set(Panel panel, Map<String,Serializable> state);
    
    
// -- Getters : ----------------------------------------------------------------
    
    abstract public List<Panel> getPanels(Predicate<Panel> selector);
    
    abstract public Panel getPanel(JComponent view);
    
    
// -- Event and listener handling : --------------------------------------------
    
    public boolean  addListener(PanelListener listener) {
        return listeners.addIfAbsent(listener);
    }
    
    public boolean  removeListener(PanelListener listener) {
        return listeners.remove(listener);
    }

}
