/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.messaging;

import java.io.Closeable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.lsst.ccs.bus.messages.LogMessage;
import org.lsst.ccs.messaging.AgentMessagingLayer;
import org.lsst.ccs.utilities.logging.LogPropertiesLoader;
import org.lsst.ccs.utilities.logging.TextFormatter;

public class LogBusHandler
extends Handler
implements Closeable {
    protected AgentMessagingLayer messagingAccess;
    protected boolean panicState = false;
    protected boolean closed = false;
    protected String subSystemName;
    protected ExecutorService executor = Executors.newSingleThreadExecutor(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread res = new Thread(r, "logbusHandlerExecutor");
            return res;
        }
    });
    protected volatile boolean logBusInitialized = false;

    public LogBusHandler(AgentMessagingLayer messagingAccess) {
        this.messagingAccess = messagingAccess;
        this.init();
    }

    private void init() {
        this.setLevel(Level.WARNING);
        String className = this.getClass().getCanonicalName();
        Formatter formatter = LogPropertiesLoader.loaderGetFormatterProperty((String)(className + ".formatter"), (Formatter)new TextFormatter());
        this.setFormatter(formatter);
        Level level = LogPropertiesLoader.loaderGetLevelProperty((String)(className + ".level"), (Level)Level.WARNING);
        this.setLevel(level);
    }

    public boolean inPanicState() {
        return this.panicState;
    }

    public void setPanicState(boolean panicState) {
        this.panicState = panicState;
    }

    @Override
    public synchronized void publish(LogRecord record) {
        Object object;
        Object[] objects;
        if (this.closed) {
            return;
        }
        Level curLevel = record.getLevel();
        if (curLevel == null) {
            curLevel = Level.SEVERE;
            record.setLevel(curLevel);
        }
        if (curLevel.equals(Level.SEVERE) && (objects = record.getParameters()) != null && objects.length > 0 && (object = objects[0]) instanceof LogMessage) {
            Throwable th = record.getThrown();
            this.getErrorManager().error("suspected panic for: " + object, th instanceof Exception ? (Exception)th : null, 1);
            return;
        }
        if (!this.inPanicState() && this.isLoggable(record)) {
            try {
                LogMessage event = this.generateLogEvent(record);
                this.executor.submit(() -> {
                    this.sendLogEvent(event);
                    return null;
                });
            }
            catch (Throwable th) {
                this.setPanicState(true);
                this.getErrorManager().error("suspected panic for: " + th.toString(), th instanceof Exception ? (Exception)th : null, 1);
            }
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public synchronized void close() throws SecurityException {
        this.closed = true;
        this.executor.shutdown();
    }

    @Override
    public void setLevel(Level level) {
        if (!this.logBusInitialized) {
            if (level.equals(Level.OFF)) {
                super.setLevel(level);
                return;
            }
            LogRecord record = new LogRecord(Level.FINE, "starting log bus");
            this.sendLogEvent(this.generateLogEvent(record));
            this.logBusInitialized = true;
        }
        super.setLevel(level);
    }

    void sendLogEvent(LogMessage event) {
        if (this.messagingAccess != null) {
            this.messagingAccess.sendLogMessage(event);
        }
    }

    LogMessage generateLogEvent(LogRecord record) {
        String threadName = Thread.currentThread().getName();
        String loggerName = record.getLoggerName();
        String sourceName = record.getSourceClassName() + "#" + record.getSourceMethodName();
        Formatter formatter = this.getFormatter();
        String formattedDetail = formatter != null ? this.getFormatter().format(record) : String.valueOf(record);
        String levelString = String.valueOf(record.getLevel());
        return new LogMessage(threadName, loggerName, sourceName, formattedDetail, levelString);
    }
}

