/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.command;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.lsst.ccs.command.AmbiguousCommandException;
import org.lsst.ccs.command.BasicCommand;
import org.lsst.ccs.command.CommandArgumentMatchException;
import org.lsst.ccs.command.Dictionary;
import org.lsst.ccs.command.DictionaryCommand;
import org.lsst.ccs.command.DictionaryCompleter;
import org.lsst.ccs.command.DictionaryHelpGenerator;

public class CompositeCommandDictionary
implements Dictionary {
    private static final long serialVersionUID = 6746559441105266344L;
    private final LinkedHashSet<Dictionary> dicts = new LinkedHashSet();
    private final CompositeCommandDictionaryCompleter completer = new CompositeCommandDictionaryCompleter(this.dicts);

    public void add(Dictionary commandDictionary) {
        this.dicts.add(commandDictionary);
    }

    public void remove(Dictionary commandDictionary) {
        this.dicts.remove(commandDictionary);
    }

    void clear() {
        this.dicts.clear();
    }

    @Override
    public DictionaryCompleter getDictionaryCompleter() {
        return this.completer;
    }

    @Override
    public boolean containsCommand(BasicCommand tc) throws CommandArgumentMatchException {
        ArrayList<CommandArgumentMatchException> exceptions = new ArrayList<CommandArgumentMatchException>();
        for (Dictionary dict : this.dicts) {
            try {
                if (!dict.containsCommand(tc)) continue;
                return true;
            }
            catch (CommandArgumentMatchException ex) {
                exceptions.add(ex);
            }
        }
        CommandArgumentMatchException.throwExceptionIfNeeded(exceptions);
        return false;
    }

    @Override
    public DictionaryCommand findCommand(BasicCommand tc) throws CommandArgumentMatchException {
        ArrayList<DictionaryCommand> matches = new ArrayList<DictionaryCommand>();
        ArrayList<CommandArgumentMatchException> exceptions = new ArrayList<CommandArgumentMatchException>();
        for (Dictionary dict : this.dicts) {
            try {
                if (!dict.containsCommand(tc)) continue;
                matches.add(dict.findCommand(tc));
            }
            catch (CommandArgumentMatchException ex) {
                exceptions.add(ex);
            }
        }
        if (matches.isEmpty()) {
            CommandArgumentMatchException.throwExceptionIfNeeded(exceptions);
            return null;
        }
        if (matches.size() == 1) {
            return (DictionaryCommand)matches.get(0);
        }
        throw new AmbiguousCommandException("Found " + matches.size() + " matches when looking for command " + tc.getCommand() + " with " + tc.getArgumentCount() + " arguments");
    }

    @Override
    public Iterator<DictionaryCommand> iterator() {
        ArrayList<DictionaryCommand> allCommands = new ArrayList<DictionaryCommand>();
        for (Dictionary dict : this.dicts) {
            for (DictionaryCommand def : dict) {
                allCommands.add(def);
            }
        }
        return allCommands.iterator();
    }

    @Override
    public int size() {
        int result = 0;
        for (Dictionary dict : this.dicts) {
            result += dict.size();
        }
        return result;
    }

    @Override
    public DictionaryHelpGenerator getHelpGenerator() {
        return new CompositeCommandDictionaryHelpGenerator(this.dicts);
    }

    private static class CompositeCommandDictionaryCompleter
    implements DictionaryCompleter {
        private static final long serialVersionUID = -6939187939493084396L;
        private final Set<Dictionary> dicts;

        CompositeCommandDictionaryCompleter(Set<Dictionary> dicts) {
            this.dicts = dicts;
        }

        @Override
        public int complete(String buffer, int cursor, List<CharSequence> list) {
            ArrayList<CharSequence> compositeCompletionList = new ArrayList<CharSequence>();
            int returnValue = -1;
            for (Dictionary dict : this.dicts) {
                int completionValue;
                ArrayList<CharSequence> innerCompletionList = new ArrayList<CharSequence>();
                DictionaryCompleter innerCompleter = dict.getDictionaryCompleter();
                if (innerCompleter == null || (completionValue = innerCompleter.complete(buffer, cursor, innerCompletionList)) < returnValue || completionValue == -1) continue;
                if (completionValue > returnValue) {
                    compositeCompletionList.clear();
                }
                compositeCompletionList.addAll(innerCompletionList);
                returnValue = completionValue;
            }
            list.addAll(compositeCompletionList);
            return returnValue;
        }
    }

    private static class CompositeCommandDictionaryHelpGenerator
    implements DictionaryHelpGenerator {
        private static final long serialVersionUID = -960170507549440673L;
        private final Set<Dictionary> dictionaries;

        CompositeCommandDictionaryHelpGenerator(Set<Dictionary> dicts) {
            this.dictionaries = dicts;
        }

        @Override
        public boolean hasHelp(DictionaryCommand command) {
            for (Dictionary dic : this.dictionaries) {
                DictionaryHelpGenerator helpGenerator = dic.getHelpGenerator();
                if (helpGenerator == null || !helpGenerator.hasHelp(command)) continue;
                return true;
            }
            return false;
        }

        @Override
        public String modifyHelpForCommand(DictionaryCommand command, String help, boolean compact) {
            for (Dictionary dic : this.dictionaries) {
                DictionaryHelpGenerator helpGenerator = dic.getHelpGenerator();
                if (helpGenerator == null || !helpGenerator.hasHelp(command)) continue;
                help = helpGenerator.modifyHelpForCommand(command, help, compact);
            }
            return help;
        }
    }
}

