/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.config;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.lsst.ccs.config.WriterProvider;

class InMemoryWriterProvider
implements WriterProvider {
    private final Map<String, ByteArrayOutputStream> propertiesMap = new HashMap<String, ByteArrayOutputStream>();

    InMemoryWriterProvider() {
    }

    @Override
    public PrintWriter getPrintWriter(String configName, String tagName, String categoryName) throws IOException {
        String configFileName = new WriterProvider.ConfigurationFileName(tagName, configName, categoryName).getFullName();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        OutputStreamWriter writer = new OutputStreamWriter(bos);
        this.propertiesMap.put(configFileName, bos);
        return new PrintWriter(writer);
    }

    public String printConfig(String configFileName) {
        if (!configFileName.endsWith(".properties")) {
            configFileName = configFileName + ".properties";
        }
        return this.propertiesMap.get(configFileName).toString();
    }

    public String printConfigNames() {
        String result = "[";
        for (String s : this.propertiesMap.keySet()) {
            result = result + s + ",";
        }
        return result.substring(0, result.length() - 1) + "]";
    }

    @Override
    public Properties getConfigurationProperties(String configName, String tag, String cat) throws IOException {
        String configFileName = new WriterProvider.ConfigurationFileName(tag, configName, cat).getFullName();
        Properties props = new Properties();
        ByteArrayOutputStream bos = this.propertiesMap.get(configFileName);
        if (bos == null) {
            return null;
        }
        byte[] array = bos.toByteArray();
        props.load(new InputStreamReader(new ByteArrayInputStream(array)));
        return props;
    }

    public void clearPropertiesMap() {
        this.propertiesMap.clear();
    }

    @Override
    public Set<String> findMatchingConfigurations(String pattern) {
        Pattern p = Pattern.compile(pattern);
        return this.propertiesMap.keySet().stream().filter(p.asPredicate()).collect(Collectors.toSet());
    }
}

