/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.config;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import org.hibernate.annotations.Immutable;
import org.lsst.ccs.config.AParameterConfiguration;
import org.lsst.ccs.config.AParameterDescription;
import org.lsst.ccs.config.ASubsystemDescription;
import org.lsst.ccs.config.AValueEvent;
import org.lsst.ccs.config.ConfigProfile;
import org.lsst.ccs.config.ImmutableStateException;
import org.lsst.ccs.config.PackCst;
import org.lsst.ccs.config.ParameterConfiguration;
import org.lsst.ccs.config.ParameterDescription;
import org.lsst.ccs.config.ParameterPath;
import org.lsst.ccs.config.SubsystemDescription;
import org.lsst.ccs.utilities.logging.Logger;

@Table(name="AConfigProfile", uniqueConstraints={@UniqueConstraint(columnNames={"name", "tag", "subsystemName"})})
@Entity
@Immutable
class AConfigProfile
extends ConfigProfile
implements Cloneable {
    private static final long serialVersionUID = -6199141309488812631L;
    @Id
    @GeneratedValue
    private long id;
    @ManyToOne(fetch=FetchType.EAGER)
    private ASubsystemDescription subsystemDesc;
    private long subsystemId;
    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    private Set<AParameterConfiguration> parameterConfigurations = new HashSet<AParameterConfiguration>();
    @Transient
    private Set<AParameterConfiguration> unModifiableConfigurations = Collections.unmodifiableSet(this.parameterConfigurations);
    private boolean isDirty;

    AConfigProfile() {
    }

    AConfigProfile(ASubsystemDescription subsystemDesc, String categoryName, String configName) {
        super(subsystemDesc.getSubsystemName(), subsystemDesc.getTag(), categoryName, configName);
        this.subsystemDesc = subsystemDesc;
        this.subsystemId = subsystemDesc.getId();
        long endDate = subsystemDesc.getEndTimestamp();
        if (endDate != PackCst.STILL_VALID) {
            throw new IllegalArgumentException("using deprecated subsystem");
        }
        this.isDirty = false;
    }

    AConfigProfile(AConfigProfile anotherConfig, boolean toEngineering, String newName) {
        this(anotherConfig.getSubsystemDesc(), anotherConfig.getCategoryName(), newName);
        for (AParameterConfiguration parmConfig : anotherConfig.getParameterConfigurations()) {
            AParameterConfiguration copyParm = new AParameterConfiguration(parmConfig, toEngineering);
            this.addParameterConfigurations(copyParm);
        }
        this.isDirty = toEngineering ? anotherConfig.isDirty : false;
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    protected void setId(long id) {
        this.id = id;
    }

    @Override
    public SubsystemDescription getSubsystemDescription() {
        return this.subsystemDesc;
    }

    @Override
    public Set<? extends ParameterConfiguration> getModifiedParameters() {
        return this.getParameterConfigurations();
    }

    @Override
    public ParameterConfiguration temporaryChangeConfigurationValue(String parameterPath, long time, String value) {
        ParameterPath path = ParameterPath.valueOf(parameterPath);
        AParameterConfiguration parameter = (AParameterConfiguration)this.fetch(path);
        if (parameter == null) {
            AParameterDescription description = (AParameterDescription)this.subsystemDesc.fetch(path);
            parameter = new AParameterConfiguration(description);
            this.addParameterConfigurations(parameter);
        }
        parameter.addValueEvent(new AValueEvent(time, value));
        this.isDirty = true;
        return parameter;
    }

    ASubsystemDescription getSubsystemDesc() {
        return this.subsystemDesc;
    }

    void setSubsystemDesc(ASubsystemDescription subsystemDesc) {
        this.subsystemDesc = subsystemDesc;
    }

    public Set<AParameterConfiguration> getParameterConfigurations() {
        if (this.unModifiableConfigurations.size() != this.parameterConfigurations.size()) {
            this.unModifiableConfigurations = Collections.unmodifiableSet(this.parameterConfigurations);
        }
        return this.unModifiableConfigurations;
    }

    void setParameterConfigurations(Set<AParameterConfiguration> parameterConfigurations) {
        this.parameterConfigurations = parameterConfigurations;
        this.unModifiableConfigurations = Collections.unmodifiableSet(parameterConfigurations);
    }

    public AConfigProfile clone() {
        AConfigProfile res = null;
        try {
            res = (AConfigProfile)super.clone();
            HashSet<AParameterConfiguration> newSet = new HashSet<AParameterConfiguration>();
            for (AParameterConfiguration parmConfig : this.parameterConfigurations) {
                newSet.add(parmConfig.clone());
            }
            res.setParameterConfigurations(newSet);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return res;
    }

    public long getSubsystemId() {
        return this.subsystemId;
    }

    void setSubsystemId(long subsystemId) {
        this.subsystemId = subsystemId;
    }

    @Override
    public void setRemarks(String remarks) {
        super.setRemarks(remarks);
    }

    @Override
    public void addParameterConfiguration(String parameterName, String value) {
        ParameterDescription description = this.subsystemDesc.fetch(parameterName);
        if (description != null) {
            this.addParameterConfigurations(new AParameterConfiguration((AParameterDescription)description, value));
        } else {
            Logger.getLogger((String)"org.lsst.ccs.config").warn((Object)("incoherent name for parameter : " + parameterName + " : ignored"));
        }
    }

    public void addParameterConfigurations(AParameterConfiguration ... parameterConfigurations) {
        if (this.isReadOnly()) {
            throw new ImmutableStateException("no modification of registered data");
        }
        for (AParameterConfiguration parameterConfiguration : parameterConfigurations) {
            AParameterDescription description = parameterConfiguration.getParameterDescription();
            if (description.getCategory().equals(this.getCategoryName())) {
                this.parameterConfigurations.add(parameterConfiguration);
                continue;
            }
            Logger.getLogger((String)"org.lsst.ccs.config").warn((Object)("The property " + description.getParameterName() + " does not belong to the category specified by the property file name : " + this.getCategoryName()));
        }
    }

    @Override
    public void addParameterConfigurations(ParameterConfiguration ... parameterConfigurations) {
        this.addParameterConfigurations(this.buildSafeArray(parameterConfigurations));
    }

    private AParameterConfiguration[] buildSafeArray(ParameterConfiguration ... parameterConfigurations) {
        AParameterConfiguration[] parms = new AParameterConfiguration[parameterConfigurations.length];
        for (int ix = 0; ix < parameterConfigurations.length; ++ix) {
            ParameterConfiguration conf = parameterConfigurations[ix];
            if (!(conf instanceof AParameterConfiguration)) {
                throw new IllegalArgumentException("deprecated parameter Configuration");
            }
            parms[ix] = (AParameterConfiguration)conf;
        }
        return parms;
    }

    @Override
    public void removeParameterConfigurations(ParameterConfiguration ... parameterConfigurations) {
        if (this.isReadOnly()) {
            throw new ImmutableStateException("Parameter Configuration list");
        }
        for (ParameterConfiguration parameterConfiguration : parameterConfigurations) {
            this.parameterConfigurations.remove(parameterConfiguration);
        }
    }

    @Override
    public boolean isDirty() {
        return this.isDirty;
    }
}

