/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.trending;

import java.io.Serializable;
import java.util.ArrayList;
import org.freehep.application.Application;
import org.freehep.application.studio.Studio;
import org.freehep.jas.plugin.plotter.DefaultPage;
import org.freehep.jas.services.PlotRegion;
import org.freehep.jas.services.Plotter;
import org.lsst.ccs.gconsole.plugins.trending.LsstTrendingPlugin;
import org.lsst.ccs.gconsole.plugins.trending.TrendPlotter;

public class TrendingPanel
extends DefaultPage {
    private final LsstTrendingPlugin plugin;
    private volatile long lastRefresh;

    public TrendingPanel(LsstTrendingPlugin plugin, String title) {
        super((Studio)Application.getApplication(), plugin.getPlotFactory(), title);
        this.plugin = plugin;
        this.createRegions(1, 1);
    }

    public long getLastRefresh() {
        return this.lastRefresh;
    }

    public void setLastRefresh(long lastRefresh) {
        this.lastRefresh = lastRefresh;
    }

    @Override
    public boolean close() {
        boolean out = super.close();
        if (out) {
            this.plugin.closePage(this);
        }
        return out;
    }

    Descriptor save() {
        Descriptor desc = new Descriptor();
        desc.setTitle(this.title());
        desc.setRows(this.rows());
        desc.setColumns(this.columns());
        int n = this.numberOfRegions();
        ArrayList<TrendPlotter.Descriptor> plotterDescriptors = new ArrayList<TrendPlotter.Descriptor>(n);
        for (int i = 0; i < n; ++i) {
            TrendPlotter.Descriptor plotterDescriptor;
            Plotter plotter;
            PlotRegion region = this.region(i);
            if (region == null || (plotter = region.currentPlot()) == null || !(plotter instanceof TrendPlotter) || (plotterDescriptor = ((TrendPlotter)plotter).save()) == null) continue;
            plotterDescriptors.add(plotterDescriptor);
        }
        desc.setPlotters(plotterDescriptors.toArray(new TrendPlotter.Descriptor[0]));
        return desc;
    }

    void restore(Descriptor desc) {
        int rows = desc.getRows();
        int columns = desc.getColumns();
        if (rows != 1 || columns != 1) {
            this.createRegions(columns, rows);
        }
        int i = 0;
        for (TrendPlotter.Descriptor plotterDescriptor : desc.getPlotters()) {
            TrendPlotter plotter = this.plugin.create();
            LsstTrendingPlugin.showPlotter(plotter, this.region(i++));
            plotter.restore(plotterDescriptor);
        }
    }

    public static class Descriptor
    implements Serializable {
        private String title;
        private int rows;
        private int columns;
        private TrendPlotter.Descriptor[] plotters;

        public TrendPlotter.Descriptor[] getPlotters() {
            return this.plotters;
        }

        public void setPlotters(TrendPlotter.Descriptor[] plotters) {
            this.plotters = plotters;
        }

        public TrendPlotter.Descriptor getPlotters(int index) {
            return this.plotters[index];
        }

        public void setPlotters(int index, TrendPlotter.Descriptor plotters) {
            this.plotters[index] = plotters;
        }

        public int getColumns() {
            return this.columns;
        }

        public void setColumns(int columns) {
            this.columns = columns;
        }

        public int getRows() {
            return this.rows;
        }

        public void setRows(int rows) {
            this.rows = rows;
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }
    }
}

