/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.trending;

import jas.hist.DataSource;
import jas.hist.HasStyle;
import jas.hist.HistogramUpdate;
import jas.hist.JASHist1DHistogramStyle;
import jas.hist.JASHistStyle;
import jas.hist.XYDataSource;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Observable;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import org.freehep.jas.plugin.plotter.DefaultPlotter;
import org.freehep.jas.plugin.plotter.DefaultRegion;
import org.freehep.jas.plugin.plotter.JAS3DataSource;
import org.freehep.jas.plugin.tree.FTreePath;
import org.freehep.jas.services.PlotPage;
import org.freehep.jas.services.PlotRegion;
import org.freehep.jas.services.Plotter;
import org.freehep.swing.popup.HasPopupItems;
import org.lsst.ccs.gconsole.plugins.trending.LsstTrendingPlugin;
import org.lsst.ccs.gconsole.plugins.trending.Trend;
import org.lsst.ccs.gconsole.plugins.trending.TrendData;
import org.lsst.ccs.gconsole.plugins.trending.TrendingChannel;
import org.lsst.ccs.gconsole.plugins.trending.timeselection.TimeWindow;

public class TrendPlotter
implements Plotter {
    private static final Color[] colors = new Color[]{Color.BLUE, Color.RED, Color.GREEN, Color.MAGENTA, Color.ORANGE, Color.CYAN, Color.DARK_GRAY, Color.LIGHT_GRAY};
    private final LsstTrendingPlugin plugin;
    private final Plotter plotter;
    private final ArrayList<Trend> trends = new ArrayList(1);
    private final ArrayList<Jas3Source> data = new ArrayList(1);
    private PlotRegion region;
    private Trend.Meta metaOnPoint;
    private EnumSet<Trend.Meta> metaOffPoint;
    private long[] rangeT;
    private double[] rangeY;

    public TrendPlotter(LsstTrendingPlugin plugin) {
        this.plugin = plugin;
        this.plotter = plugin.getPlotFactory().createPlotterFor(JAS3DataSource.class);
        try {
            DefaultPlotter dp = (DefaultPlotter)this.plotter;
            dp.getPlot().getXAxis().setRangeAutomatic(true);
            dp.getPlot().setShowStatistics(false);
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        this.reset();
    }

    public PlotRegion getRegion() {
        return this.region;
    }

    public void setRegion(PlotRegion region) {
        this.region = region;
        try {
            DefaultRegion dr = (DefaultRegion)region;
            dr.addPopupItems(new Popup());
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    public EnumSet<Trend.Meta> getMeta() {
        EnumSet<Trend.Meta> out = this.metaOnPoint == null ? EnumSet.noneOf(Trend.Meta.class) : EnumSet.of(this.metaOnPoint);
        out.addAll(this.metaOffPoint);
        return out;
    }

    public void setMeta(EnumSet<Trend.Meta> extras) {
    }

    public boolean isActive() {
        if (this.region != null) {
            try {
                return ((JComponent)this.viewable()).getTopLevelAncestor() != null;
            }
            catch (ClassCastException | NullPointerException runtimeException) {
                // empty catch block
            }
        }
        return false;
    }

    public List<Trend> getTrends() {
        return Collections.unmodifiableList(this.trends);
    }

    public boolean isEmpty() {
        return this.trends.isEmpty();
    }

    @Override
    public void plot(Object timeHistory, int mode) {
        this.plot(timeHistory, mode, null, "");
    }

    @Override
    public void plot(Object timeHistory, int mode, Object style, String options) {
        if (!(timeHistory instanceof Trend) || mode != 0 && mode != 1) {
            return;
        }
        Trend trend = (Trend)timeHistory;
        trend.setPlotter(this);
        if (!this.trends.isEmpty()) {
            if (mode == 0) {
                this.clear();
            } else if (this.trends.size() < this.data.size()) {
                this.plotter.clear();
                Jas3Source other = this.data.get(0);
                this.data.clear();
                this.data.add(other);
                this.plotter.plot(other, 0);
            }
        }
        this.trends.add(trend);
        Jas3Source ds = new Jas3Source(trend, this.metaOnPoint, null);
        trend.addListener(ds);
        this.data.add(ds);
        this.plotter.plot(ds, mode);
        if (!this.metaOffPoint.isEmpty() && this.trends.size() == 1 && mode == 0) {
            for (Trend.Meta meta : this.metaOffPoint) {
                for (String key : meta.getKeys()) {
                    ds = new Jas3Source(trend, meta, key);
                    trend.addListener(ds);
                    this.data.add(ds);
                    this.plotter.plot(ds, 1);
                }
            }
        }
        try {
            DefaultPlotter dp = (DefaultPlotter)this.plotter;
            dp.getPlot().getXAxis().setRangeAutomatic(true);
            if (this.trends.size() == 1) {
                dp.getPlot().setTitle(this.trends.get(0).getChannel().getTitle());
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    @Override
    public void remove(Object data) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void clear() {
        if (!this.trends.isEmpty()) {
            this.clean();
            this.reset();
        }
    }

    @Override
    public Component viewable() {
        return this.plotter.viewable();
    }

    @Override
    public List<Object> getData() {
        return Collections.unmodifiableList(this.trends);
    }

    public void toFront() {
        PlotPage page;
        if (this.region != null && (page = this.region.getPage()) != null) {
            page.setCurrentRegion(this.region);
            page.showPage();
        }
    }

    private void plot(List<Trend> trendList) {
        if (trendList.size() == 1) {
            this.plot(trendList.get(0), 0);
        } else {
            trendList.forEach(trend -> this.plot(trend, 1));
        }
    }

    private void plot() {
        if (this.trends.size() > 1) {
            this.trends.forEach(trend -> trend.fireEvent());
        } else if (this.trends.size() == 1) {
            Trend trend2 = this.trends.get(0);
            this.clean();
            this.plot(trend2, 0);
        }
    }

    private void clean() {
        this.trends.forEach(trend -> trend.removeAllListeners());
        this.trends.clear();
        this.plotter.clear();
        this.data.clear();
    }

    private void reset() {
        this.metaOnPoint = null;
        this.metaOffPoint = EnumSet.noneOf(Trend.Meta.class);
        this.plugin.getPreferences().getDrawMeta().forEach(m -> {
            if (m.isOnPoint()) {
                this.metaOnPoint = m;
            } else {
                this.metaOffPoint.add((Trend.Meta)((Object)m));
            }
        });
    }

    Descriptor save() {
        Descriptor desc = new Descriptor();
        if (!this.trends.isEmpty()) {
            int n = this.trends.size();
            TrendDescriptor[] tds = new TrendDescriptor[n];
            for (int i = 0; i < n; ++i) {
                Trend trend = this.trends.get(i);
                TrendDescriptor td = new TrendDescriptor();
                String path = trend.getChannel().getPath();
                td.setPath(path);
                String title = trend.getChannel().getTitle();
                if (!path.equals(title)) {
                    td.setTitle(title);
                }
                td.setTimeWindow(trend.getTimeWindow().toCompressedString());
                tds[i] = td;
            }
            desc.setTrends(tds);
        }
        if (this.metaOnPoint != null) {
            desc.setOnPointMeta(this.metaOnPoint.name());
        }
        if (!this.metaOffPoint.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            this.metaOffPoint.forEach(m -> sb.append(m.name()).append("+"));
            desc.setOffPointMeta(sb.substring(0, sb.length() - 1));
        }
        if (this.rangeT != null) {
            desc.setRangeT(Arrays.copyOf(this.rangeT, this.rangeT.length));
        }
        if (this.rangeY != null) {
            desc.setRangeY(Arrays.copyOf(this.rangeY, this.rangeY.length));
        }
        return desc;
    }

    void restore(Descriptor desc) {
        TrendDescriptor[] tds;
        this.rangeT = desc.getRangeT();
        this.rangeY = desc.getRangeY();
        String ms = desc.getOnPointMeta();
        if (ms != null) {
            this.metaOnPoint = Trend.Meta.valueOf(ms);
        }
        ms = desc.getOffPointMeta();
        this.metaOffPoint = EnumSet.noneOf(Trend.Meta.class);
        if (ms != null) {
            String[] ss;
            for (String s : ss = ms.split("\\+")) {
                this.metaOffPoint.add(Trend.Meta.valueOf(s));
            }
        }
        if ((tds = desc.getTrends()) != null) {
            ArrayList<Trend> trendList = new ArrayList<Trend>(tds.length);
            ArrayList<TrendingChannel> knownChannels = this.plugin.getSourcesManager().getChannels();
            for (TrendDescriptor td : tds) {
                String path = td.getPath();
                String title = td.getTitle();
                TrendingChannel channel = null;
                for (TrendingChannel ch : knownChannels) {
                    if (!title.equals(ch.getTitle())) continue;
                    if (path.equals(ch.getPath())) {
                        channel = ch;
                        break;
                    }
                    if (channel != null) continue;
                    channel = ch;
                }
                if (channel == null) continue;
                Trend trend = new Trend(channel);
                TimeWindow timeWindow = this.plugin.getTimeWindowSelector().getTimeWindow(td.getTimeWindow());
                trend.setTimeWindow(timeWindow);
                trendList.add(trend);
            }
            if (!trendList.isEmpty()) {
                this.plot(trendList);
                this.plugin.refresh(this.trends);
                this.toFront();
            }
        }
    }

    public static class TrendDescriptor
    implements Serializable {
        private String path;
        private String title;
        private String timeWindow;

        public String getTimeWindow() {
            return this.timeWindow;
        }

        public void setTimeWindow(String timeWindow) {
            this.timeWindow = timeWindow;
        }

        public String getTitle() {
            return this.title == null ? this.path : this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }
    }

    public static class Descriptor
    implements Serializable {
        private TrendDescriptor[] trends;
        private String onPointMeta;
        private String offPointMeta;
        private long[] rangeT;
        private double[] rangeY;

        public double[] getRangeY() {
            return this.rangeY;
        }

        public void setRangeY(double[] rangeY) {
            this.rangeY = rangeY;
        }

        public long[] getRangeT() {
            return this.rangeT;
        }

        public void setRangeT(long[] rangeT) {
            this.rangeT = rangeT;
        }

        public String getOffPointMeta() {
            return this.offPointMeta;
        }

        public void setOffPointMeta(String offPointMeta) {
            this.offPointMeta = offPointMeta;
        }

        public String getOnPointMeta() {
            return this.onPointMeta;
        }

        public void setOnPointMeta(String onPointMeta) {
            this.onPointMeta = onPointMeta;
        }

        public TrendDescriptor[] getTrends() {
            return this.trends;
        }

        public void setTrends(TrendDescriptor[] trends) {
            this.trends = trends;
        }
    }

    public static class Style {
        Trend.Meta onPoint;
        EnumSet<Trend.Meta> offPoint;

        public Style() {
        }

        public Style(Trend.Meta onPoint, EnumSet<Trend.Meta> offPoint) {
            this.onPoint = onPoint;
            this.offPoint = offPoint;
        }

        public Trend.Meta getOnPoint() {
            return this.onPoint;
        }

        public void setOnPoint(Trend.Meta onnPoint) {
            this.onPoint = onnPoint;
        }

        public EnumSet<Trend.Meta> getOffPoint() {
            return this.offPoint;
        }

        public void setOffPoint(EnumSet<Trend.Meta> offPoint) {
            this.offPoint = offPoint;
        }
    }

    private class Popup
    implements HasPopupItems {
        private Popup() {
        }

        public JPopupMenu modifyPopupMenu(JPopupMenu menu, Component componentt, Point point) {
            menu.insert(new JSeparator(), 0);
            JMenu metaMenu = new JMenu("Show metadata");
            ButtonGroup bg = new ButtonGroup();
            Trend.Meta.getOnPointSet().forEach(meta -> {
                JRadioButtonMenuItem item = new JRadioButtonMenuItem(meta.toString(), TrendPlotter.this.metaOnPoint == meta);
                bg.add(item);
                item.addActionListener(e -> {
                    Trend.Meta selected = Trend.Meta.valueOf(e.getActionCommand());
                    if (selected != TrendPlotter.this.metaOnPoint) {
                        TrendPlotter.this.metaOnPoint = selected;
                    } else {
                        TrendPlotter.this.metaOnPoint = null;
                    }
                    TrendPlotter.this.trends.forEach(trend -> trend.fireEvent());
                });
                metaMenu.add(item);
            });
            metaMenu.addSeparator();
            Trend.Meta.getOffPointSet().forEach(meta -> {
                JCheckBoxMenuItem item = new JCheckBoxMenuItem(meta.toString(), TrendPlotter.this.metaOffPoint.contains(meta));
                item.setEnabled(TrendPlotter.this.trends.size() < 2);
                item.addActionListener(e -> {
                    JCheckBoxMenuItem mi;
                    boolean isSelected;
                    Trend.Meta m = Trend.Meta.valueOf(e.getActionCommand());
                    boolean wasSelected = TrendPlotter.this.metaOffPoint.contains((Object)m);
                    if (wasSelected != (isSelected = (mi = (JCheckBoxMenuItem)e.getSource()).isSelected())) {
                        if (wasSelected) {
                            TrendPlotter.this.metaOffPoint.remove((Object)m);
                        } else {
                            TrendPlotter.this.metaOffPoint.add(m);
                        }
                        TrendPlotter.this.plot();
                    }
                });
                metaMenu.add(item);
            });
            menu.insert(metaMenu, 0);
            return menu;
        }
    }

    private class Jas3Source
    extends Observable
    implements JAS3DataSource,
    XYDataSource,
    HasStyle,
    Trend.Listener {
        private final String title;
        private final String key;
        private long[] t;
        private double[] y;
        private double[] plusError;
        private double[] minusError;
        private final JASHist1DHistogramStyle style = new JASHist1DHistogramStyle();

        Jas3Source(Trend trend, Trend.Meta meta, String key) {
            Color color;
            this.key = key;
            if (key == null) {
                this.title = trend.getChannel().getTitle();
                color = colors[TrendPlotter.this.trends.indexOf(trend) % colors.length];
                this.style.setShowDataPoints(true);
                this.style.setShowErrorBars(true);
            } else {
                this.title = meta.toString();
                color = meta.getColor();
                this.style.setShowDataPoints(false);
                this.style.setShowErrorBars(false);
            }
            this.style.setDataPointColor(color);
            this.style.setErrorBarColor(color);
            this.style.setLineColor(color);
            this.style.setDataPointStyle(0);
            this.style.setShowHistogramBars(false);
            this.style.setShowLinesBetweenPoints(true);
            this.populate(trend);
        }

        private void populate(Trend trend) {
            TrendData td = trend.getData();
            if (td == null) {
                this.t = null;
                this.minusError = null;
                this.plusError = null;
                this.y = null;
                return;
            }
            if (this.key == null) {
                this.t = td.getTime();
                this.y = td.getValue();
                if (TrendPlotter.this.metaOnPoint == null) {
                    this.plusError = null;
                    this.minusError = null;
                } else {
                    List<String> keys = TrendPlotter.this.metaOnPoint.getKeys();
                    int n = keys.size();
                    double[][] in = new double[n + 1][];
                    in[0] = this.y;
                    for (int i = 0; i < n; ++i) {
                        in[i + 1] = td.getValue(keys.get(i));
                    }
                    double[][] out = TrendPlotter.this.metaOnPoint.getBars(in);
                    this.minusError = out[0];
                    this.plusError = out[1];
                }
            } else {
                this.t = td.getTime(this.key);
                this.y = td.getValue(this.key);
            }
        }

        @Override
        public void destroy() {
        }

        @Override
        public void modifyPopupMenu(JPopupMenu jPopupMenu, Component component) {
        }

        @Override
        public DataSource dataSource() {
            return this;
        }

        @Override
        public FTreePath path() {
            return new FTreePath(this.getTitle());
        }

        @Override
        public String[] axisLabels() {
            return null;
        }

        @Override
        public void setAxisType(int type) {
        }

        public int getNPoints() {
            return this.t == null ? 0 : this.t.length;
        }

        public double getX(int i) {
            return (double)this.t[i] / 1000.0;
        }

        public double getY(int i) {
            return this.y[i];
        }

        public double getPlusError(int i) {
            return this.plusError == null ? 0.0 : this.plusError[i];
        }

        public double getMinusError(int i) {
            return this.minusError == null ? 0.0 : this.minusError[i];
        }

        public int getAxisType() {
            return 3;
        }

        public String getTitle() {
            return this.title;
        }

        public JASHistStyle getStyle() {
            return this.style;
        }

        @Override
        public void processEvent(Trend.Event event) {
            Trend trend;
            if (TrendPlotter.this.rangeT == null) {
                try {
                    DefaultPlotter dp = (DefaultPlotter)TrendPlotter.this.plotter;
                    dp.getPlot().getXAxis().setRangeAutomatic(true);
                }
                catch (ClassCastException dp) {
                    // empty catch block
                }
            }
            if ((trend = event.getSource()) != null) {
                this.populate(trend);
                this.setChanged();
                this.notifyObservers(new HistogramUpdate(2, false));
            }
        }
    }

    static enum Option {
        EXIST,
        NEWPAGE,
        NEWPLOT,
        OVERLAY,
        SLOW,
        REPLOT;

    }
}

