/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.trending;

import java.awt.Color;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.EventListener;
import java.util.EventObject;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import javax.swing.SwingUtilities;
import org.lsst.ccs.gconsole.plugins.trending.TrendData;
import org.lsst.ccs.gconsole.plugins.trending.TrendPlotter;
import org.lsst.ccs.gconsole.plugins.trending.TrendingChannel;
import org.lsst.ccs.gconsole.plugins.trending.timeselection.TimeWindow;

public class Trend {
    private final TrendingChannel channel;
    private TrendPlotter plotter;
    private volatile TrendData data;
    private volatile TimeWindow timeWindow;
    private volatile long timestamp;
    private final CopyOnWriteArrayList<Listener> listeners = new CopyOnWriteArrayList();

    public Trend(TrendingChannel channel) {
        this.channel = channel;
    }

    public TrendingChannel getChannel() {
        return this.channel;
    }

    public TrendPlotter getPlotter() {
        return this.plotter;
    }

    void setPlotter(TrendPlotter plotter) {
        this.plotter = plotter;
    }

    public TrendData getData() {
        return this.data;
    }

    public void setData(TrendData data) {
        this.data = data;
        this.timestamp = System.currentTimeMillis();
    }

    public TimeWindow getTimeWindow() {
        return this.timeWindow;
    }

    public void setTimeWindow(TimeWindow timeWindow) {
        this.timeWindow = timeWindow;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(Listener listener) {
        this.listeners.remove(listener);
    }

    public void removeAllListeners() {
        this.listeners.clear();
    }

    public void fireEvent() {
        if (SwingUtilities.isEventDispatchThread()) {
            Event event = new Event(this);
            this.listeners.forEach(listener -> listener.processEvent(event));
        } else {
            SwingUtilities.invokeLater(this::fireEvent);
        }
    }

    public static class Event
    extends EventObject {
        Event(Trend source) {
            super(source);
        }

        @Override
        public Trend getSource() {
            return (Trend)this.source;
        }
    }

    public static interface Listener
    extends EventListener {
        public void processEvent(Event var1);
    }

    public static enum Meta {
        RANGE(null, in -> {
            int n = in[0].length;
            double[] errMin = new double[n];
            double[] errMax = new double[n];
            for (int i = 0; i < n; ++i) {
                errMin[i] = Math.max(in[0][i] - in[1][i], 0.0);
                errMax[i] = Math.max(in[2][i] - in[0][i], 0.0);
            }
            return new double[][]{errMin, errMax};
        }, "min", "max"),
        RMS(null, in -> new double[][]{in[1], in[1]}, "rms"),
        ALARM(Color.RED, null, "alarmLow", "alarmHigh"),
        WARNING(Color.GREEN, null, "warningLow", "warningHigh");

        private static final EnumSet<Meta> onPointSet;
        private static final EnumSet<Meta> offPointSet;
        private final Color color;
        private final List<String> keys;
        private final Function<double[][], double[][]> computeBars;

        private Meta(Color color, Function<double[][], double[][]> computeBars, String ... keys) {
            this.color = color;
            this.computeBars = computeBars;
            this.keys = Collections.unmodifiableList(Arrays.asList(keys));
        }

        public static EnumSet<Meta> getOnPointSet() {
            return onPointSet;
        }

        public static EnumSet<Meta> getOffPointSet() {
            return offPointSet;
        }

        public boolean isOnPoint() {
            return onPointSet.contains((Object)this);
        }

        public Color getColor() {
            return this.color;
        }

        public int size() {
            return this.keys.size();
        }

        public List<String> getKeys() {
            return this.keys;
        }

        public double[][] getBars(double[][] in) {
            if (in == null || this.computeBars == null) {
                return new double[2][];
            }
            for (double[] data : in) {
                if (data != null) continue;
                return new double[2][];
            }
            return this.computeBars.apply(in);
        }

        static {
            onPointSet = EnumSet.of(RANGE, RMS);
            offPointSet = EnumSet.of(ALARM, WARNING);
        }
    }
}

