/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.trending;

import com.sun.jersey.api.client.WebResource;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.lsst.ccs.gconsole.plugins.trending.LsstTrendingPlugin;
import org.lsst.ccs.gconsole.plugins.trending.Trend;
import org.lsst.ccs.gconsole.plugins.trending.TrendData;
import org.lsst.ccs.gconsole.plugins.trending.TrendingChannel;
import org.lsst.ccs.gconsole.plugins.trending.TrendingPreferences;
import org.lsst.ccs.gconsole.plugins.trending.TrendingSource;
import org.lsst.ccs.localdb.statusdb.server.ChannelMetaData;
import org.lsst.ccs.localdb.statusdb.server.Data;
import org.lsst.ccs.localdb.statusdb.server.DataChannel;
import org.lsst.ccs.localdb.statusdb.server.TrendingData;
import org.lsst.ccs.localdb.statusdb.server.TrendingResult;
import org.lsst.ccs.utilities.logging.Logger;

public class RestServerSource
extends TrendingSource {
    private final WebResource server;
    private final Logger logger;
    private final TrendingPreferences pref;
    private final Map<TrendingChannel, DataChannel> channels = new ConcurrentHashMap<TrendingChannel, DataChannel>();

    public RestServerSource(WebResource server, LsstTrendingPlugin plugin) {
        this.server = server;
        this.logger = plugin.getConsole().getLogger();
        this.pref = plugin.getPreferences();
    }

    public boolean connect() {
        this.channels.clear();
        try {
            DataChannel.DataChannelList channelList = (DataChannel.DataChannelList)this.server.path("listchannels").accept(new String[]{"text/xml"}).get(DataChannel.DataChannelList.class);
            this.logger.info((Object)("Connection successful, " + channelList.list.size() + " channels read from " + this.server.getURI()));
            this.channels.clear();
            channelList.list.forEach(channel -> this.channels.put(new TrendingChannel(channel.getPathAsString()), (DataChannel)channel));
            return true;
        }
        catch (RuntimeException e) {
            this.logger.warn((Object)("Unable to connect to the REST server at " + this.server.getURI()));
            return false;
        }
    }

    @Override
    public List<TrendingChannel> getChannels() {
        return new ArrayList<TrendingChannel>(this.channels.keySet());
    }

    @Override
    public TrendData get(TrendingChannel channel, long begin, long end, EnumSet<Trend.Meta> metadata, TrendData history) {
        HashSet offPoint;
        HashSet<String> onPoint;
        DataChannel dc = this.channels.get(channel);
        if (dc == null) {
            return null;
        }
        WebResource resource = this.server.path("data").path(String.valueOf(dc.getId()));
        resource = resource.queryParam("t1", String.valueOf(begin)).queryParam("t2", String.valueOf(end));
        int nBins = this.pref.getNBins();
        if (nBins > 0) {
            if (!this.pref.isUseRawData()) {
                resource = resource.queryParam("flavor", "stat");
            }
            resource = resource.queryParam("n", Integer.toString(nBins));
        } else {
            resource = resource.queryParam("flavor", this.pref.isUseRawData() ? "raw" : "stat");
        }
        Data data = (Data)resource.accept(new String[]{"text/xml"}).get(Data.class);
        TrendingResult result = data.getTrendingResult();
        if (metadata == null) {
            onPoint = null;
            offPoint = null;
        } else {
            onPoint = new HashSet<String>();
            onPoint.add("value");
            offPoint = new HashSet();
            metadata.forEach(m -> {
                if (m.isOnPoint()) {
                    onPoint.addAll(m.getKeys());
                } else {
                    offPoint.addAll(m.getKeys());
                }
            });
        }
        HashMap<String, long[]> times = new HashMap<String, long[]>();
        HashMap<String, double[]> values = new HashMap<String, double[]>();
        long lowEdge = begin;
        long highEdge = end;
        TrendingData[] dataArray = result.getTrendingDataArray();
        if (dataArray != null) {
            int n = dataArray.length;
            long[] time = new long[n];
            times.put("value", time);
            for (int i = 0; i < n; ++i) {
                TrendingData td = dataArray[i];
                time[i] = td.getAxisvalue().getValue();
                for (TrendingData.DataValue dv : td.getDatavalue()) {
                    String key2 = dv.getName();
                    if (onPoint != null && !onPoint.contains(key2)) continue;
                    double[] valueArray = (double[])values.get(key2);
                    if (valueArray == null) {
                        valueArray = new double[n];
                        values.put(key2, valueArray);
                    }
                    valueArray[i] = dv.getValue();
                }
            }
        }
        List metaList = result.getChannelMetadata();
        HashMap<String, ArrayList> metaMap = new HashMap<String, ArrayList>();
        for (ChannelMetaData meta : metaList) {
            String key3 = meta.getName();
            if (offPoint != null && !offPoint.contains(key3)) continue;
            try {
                ArrayList<MetaPoint> ps = (ArrayList<MetaPoint>)metaMap.get(key3);
                if (ps == null) {
                    ps = new ArrayList<MetaPoint>();
                    metaMap.put(key3, ps);
                }
                double value = Double.parseDouble(meta.getValue());
                long start = meta.getTstart();
                long stop = meta.getTstop();
                if (start > highEdge && start != -1L || stop < lowEdge && stop != -1L) continue;
                if (start < lowEdge) {
                    start = lowEdge;
                }
                ps.add(new MetaPoint(start, value));
                if (stop > highEdge || stop == -1L) {
                    stop = highEdge;
                }
                ps.add(new MetaPoint(stop, value));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        metaMap.forEach((key, points) -> {
            int n = points.size();
            long[] t = new long[n];
            double[] v = new double[n];
            for (int i = 0; i < n; ++i) {
                MetaPoint p = (MetaPoint)points.get(i);
                t[i] = p.time;
                v[i] = p.value;
            }
            times.put((String)key, t);
            values.put((String)key, v);
        });
        return new TrendData(times, values);
    }

    private static class MetaPoint {
        long time;
        double value;

        MetaPoint(long t, double v) {
            this.time = t;
            this.value = v;
        }
    }
}

