/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.dictionary;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.lsst.ccs.command.DictionaryArgument;
import org.lsst.ccs.command.DictionaryCommand;
import org.lsst.ccs.gconsole.plugins.dictionary.HintTextField;

public class ArgInputPanel
extends JPanel
implements ListSelectionListener {
    private JLabel[] argName;
    private HintTextField[] argInput;
    private JPanel formPane;
    private JEditorPane commandDesc;

    public ArgInputPanel() {
        this.setLayout(new BorderLayout());
        this.commandDesc = new JEditorPane();
        this.commandDesc.setBackground(new Color(237, 236, 235));
        this.commandDesc.setEditable(false);
        this.commandDesc.setContentType("text/html");
        this.commandDesc.setText("      ");
        this.add((Component)this.commandDesc, "Center");
        this.formPane = new JPanel();
        this.add((Component)this.formPane, "South");
    }

    public void clearForm() {
        this.formPane.removeAll();
        this.commandDesc.setText("       ");
    }

    public final void fillFormPane(DictionaryCommand cmd) {
        this.clearForm();
        int nbArgs = cmd.getArguments().length;
        this.formPane.setLayout(new GridLayout(nbArgs, 2));
        this.argName = new JLabel[nbArgs];
        this.argInput = new HintTextField[nbArgs];
        for (int i = 0; i < nbArgs; ++i) {
            this.argName[i] = new JLabel(cmd.getArguments()[i].getName());
            this.argInput[i] = new HintTextField(cmd.getArguments()[i].getSimpleType());
            this.formPane.add(this.argName[i]);
            this.formPane.add(this.argInput[i]);
        }
        String cmdDescString = cmd.getDescription() + "<br>";
        DictionaryArgument[] argTable = cmd.getArguments();
        String cmdArguments = "";
        for (int i = 0; i < argTable.length; ++i) {
            cmdArguments = cmdArguments + " <b>" + argTable[i].getSimpleType() + "</b>" + " " + argTable[i].getName() + " : " + argTable[i].getDescription() + "<br>";
        }
        this.commandDesc.setText("<html><h3>" + cmdDescString + "</h3><p>" + cmdArguments + "</p>");
        this.repaint();
        this.validate();
    }

    public JTextField[] getArgInput() {
        return this.argInput;
    }

    @Override
    public void valueChanged(ListSelectionEvent lse) {
        DictionaryCommand cmd = (DictionaryCommand)((JList)lse.getSource()).getSelectedValue();
        this.clearForm();
        if (cmd == null) {
            return;
        }
        this.fillFormPane(cmd);
    }
}

