/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole;

import java.awt.Panel;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Predicate;
import javax.swing.JComponent;
import org.lsst.ccs.gconsole.PanelListener;

public abstract class PanelManager {
    private final CopyOnWriteArrayList<PanelListener> listeners = new CopyOnWriteArrayList();

    public abstract Panel open(JComponent var1, Map<String, Serializable> var2);

    public abstract Panel open(JComponent var1, Panel var2);

    public abstract boolean close(Panel var1);

    public boolean close(Predicate<Panel> selector) {
        boolean closedAll = true;
        for (Panel panel : this.getPanels(selector)) {
            closedAll = this.close(panel) && closedAll;
        }
        return closedAll;
    }

    public abstract Serializable set(Panel var1, String var2, Serializable var3);

    public abstract boolean set(Panel var1, Map<String, Serializable> var2);

    public abstract List<Panel> getPanels(Predicate<Panel> var1);

    public abstract Panel getPanel(JComponent var1);

    public boolean addListener(PanelListener listener) {
        return this.listeners.addIfAbsent(listener);
    }

    public boolean removeListener(PanelListener listener) {
        return this.listeners.remove(listener);
    }
}

