/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.localdb.statusdb.trendServer;

import com.sun.jersey.spi.resource.Singleton;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.math.BigInteger;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Application;
import javax.ws.rs.ext.RuntimeDelegate;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.lsst.ccs.localdb.statusdb.model.DataDesc;
import org.lsst.ccs.localdb.statusdb.model.MetaDataData;
import org.lsst.ccs.localdb.statusdb.model.RaisedAlertData;
import org.lsst.ccs.localdb.statusdb.model.RawData;
import org.lsst.ccs.localdb.statusdb.model.StatData;
import org.lsst.ccs.localdb.statusdb.model.StatDesc;
import org.lsst.ccs.localdb.statusdb.server.ChannelMetaData;
import org.lsst.ccs.localdb.statusdb.server.Data;
import org.lsst.ccs.localdb.statusdb.server.DataChannel;
import org.lsst.ccs.localdb.statusdb.server.TrendingData;
import org.lsst.ccs.localdb.statusdb.utils.StatusdbUtils;
import org.lsst.ccs.utilities.logging.Log4JConfiguration;
import org.lsst.ccs.utilities.logging.Logger;

@Path(value="/dataserver")
@Singleton
public class DataServer {
    private SessionFactory fac;
    static Logger log;

    public DataServer() {
        Properties p = new Properties();
        String hcdName = "hibernate.connection.datasource";
        try {
            InitialContext env = new InitialContext();
            try {
                if (env.lookup("jdbc/css") != null) {
                    p.setProperty(hcdName, "jdbc/ccs");
                }
            }
            catch (NamingException namingException) {
                // empty catch block
            }
            try {
                if (env.lookup("java:comp/env/jdbc/ccs") != null) {
                    p.setProperty(hcdName, "java:comp/env/jdbc/ccs");
                }
            }
            catch (NamingException namingException) {}
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        this.fac = StatusdbUtils.getSessionFactory(p);
        log.fine((Object)"Starting Data Server");
    }

    private List<DataChannel> getListOfChannels() {
        log.fine((Object)"Loading Channel Information");
        Session sess = this.fac.openSession();
        List l = sess.createQuery("from DataDesc order by dataName").list();
        ArrayList<DataChannel> channels = new ArrayList<DataChannel>();
        log.fine((Object)("Done with the query " + l.size()));
        for (DataDesc d : l) {
            DataChannel dc = new DataChannel(d);
            dc.getMetadata().put("subsystem", d.getDataPath().getAgentName());
            channels.add(dc);
            log.debug((Object)("retrieving Data Channel path= " + dc.getPathAsString()));
        }
        sess.close();
        return channels;
    }

    @GET
    @Path(value="/data/{id}")
    public Data getData(@PathParam(value="id") long id, @QueryParam(value="t1") @DefaultValue(value="-1") long t1, @QueryParam(value="t2") @DefaultValue(value="-1") long t2, @QueryParam(value="flavor") String flavor, @QueryParam(value="n") @DefaultValue(value="30") int nbins) {
        boolean useStat = false;
        boolean useRaw = false;
        if ("stat".equals(flavor)) {
            useStat = true;
        } else if ("raw".equals(flavor)) {
            useRaw = true;
        } else {
            flavor = "unspecified";
        }
        if (t2 < 0L) {
            t2 = System.currentTimeMillis();
        }
        if (t1 < 0L) {
            t1 = t2 - 3600000L;
        }
        log.fine((Object)("request for data " + id + "[" + t1 + "," + t2 + "] " + flavor + " " + nbins));
        long rawId = id;
        if (useRaw) {
            log.debug((Object)"sending raw data");
            return this.exportRawData(rawId, t1, t2);
        }
        if (useStat) {
            StatDesc statSource = null;
            long statSourceN = -1L;
            Map<StatDesc, Long> stats = this.getAvailableStats(rawId, t1, t2);
            log.fine((Object)"stats :");
            for (Map.Entry<StatDesc, Long> s : stats.entrySet()) {
                log.debug((Object)("  " + s.getKey().getId() + " " + s.getKey().getTimeBinWidth() + " : " + s.getValue()));
                long n = s.getValue();
                if (n <= (long)(nbins / 2)) continue;
                if (statSource != null) {
                    if (n >= statSourceN) continue;
                    statSource = s.getKey();
                    statSourceN = n;
                    continue;
                }
                statSource = s.getKey();
                statSourceN = n;
            }
            if (statSource != null) {
                log.fine((Object)("sending stat from stat sampling " + statSource.getTimeBinWidth() + " nsamples " + statSourceN));
                return this.exportStatDataFromStat(statSource, t1, t2, nbins);
            }
        }
        log.debug((Object)"sending stat from raw");
        return this.exportStatDataFromRaw(rawId, t1, t2, nbins);
    }

    public List<ChannelMetaData> getMetadata(int channelId) {
        return this.getMetadata(channelId, -1L, -1L);
    }

    public List<ChannelMetaData> getMetadata(int channelId, long t1, long t2) {
        Session sess = this.fac.openSession();
        String queryStr = "from MetaDataData where dataDesc.id = :id ";
        if (t1 > -1L) {
            queryStr = queryStr + "and (endTime > :t1 or startTime = -1) ";
        }
        if (t2 > -1L) {
            queryStr = queryStr + "and startTime < :t2 ";
        }
        Query q = sess.createQuery(queryStr);
        q.setParameter("id", (Object)channelId);
        if (t1 > -1L) {
            q.setParameter("t1", (Object)t1);
        }
        if (t2 > -1L) {
            q.setParameter("t2", (Object)t2);
        }
        List l = q.list();
        sess.close();
        ArrayList<ChannelMetaData> out = new ArrayList<ChannelMetaData>();
        for (MetaDataData md : l) {
            out.add(new ChannelMetaData(md));
        }
        return out;
    }

    @GET
    @Path(value="/channelinfo/{id}")
    public ChannelMetadataList getMetadataList(@PathParam(value="id") long channelId) {
        long rawId = channelId;
        return new ChannelMetadataList(this.getMetadata((int)rawId));
    }

    @GET
    @Path(value="/listchannels")
    public DataChannel.DataChannelList getChannels() {
        return new DataChannel.DataChannelList(this.getListOfChannels());
    }

    @GET
    @Path(value="/listchannels/{subsystem}")
    public DataChannel.DataChannelList getChannels(@PathParam(value="subsystem") String subsystemName) {
        List<DataChannel> channels = this.getListOfChannels();
        ArrayList<DataChannel> subChannels = new ArrayList<DataChannel>();
        for (DataChannel dc : channels) {
            if (!dc.getPath()[0].equals(subsystemName)) continue;
            subChannels.add(dc);
        }
        return new DataChannel.DataChannelList(subChannels);
    }

    public DataChannel[] getChannels(String partialPath, int level) {
        return null;
    }

    public DataChannel[] getChannelsByKeywork(String keyword) {
        return null;
    }

    protected Map<StatDesc, Long> getAvailableStats(long rawId, long t1, long t2) {
        Session sess = this.fac.openSession();
        HashMap<StatDesc, Long> m = new HashMap<StatDesc, Long>();
        Query q = sess.createQuery("select d, count(x) from StatDesc d, StatData x where d.dataDesc.id = :id and x.statDesc = d and (x.statTimeInterval.startTime+d.timeBinWidth) >= :t1 and x.statTimeInterval.startTime <= :t2 group by d.id order by d.timeBinWidth");
        q.setLong("id", rawId);
        q.setParameter("t1", (Object)t1);
        q.setParameter("t2", (Object)t2);
        List l = q.list();
        for (Object[] r : l) {
            if (r[0] == null) continue;
            m.put((StatDesc)r[0], (Long)r[1]);
        }
        sess.close();
        return m;
    }

    protected long getAvailableRawData(long rawId, long t1, long t2) {
        Session sess = this.fac.openSession();
        Query q = sess.createQuery("select count(r) from RawData r where r.dataDesc.id = :id and r.tstamp between :t1 and :t2 order by r.tstamp");
        q.setParameter("id", (Object)rawId);
        q.setParameter("t1", (Object)t1);
        q.setParameter("t2", (Object)t2);
        long n = (Long)q.uniqueResult();
        sess.close();
        return n;
    }

    protected List<RawData> getRawData(long id, long t1, long t2) {
        Session sess = this.fac.openSession();
        Query q = sess.createQuery("from RawData r where r.dataDesc.id = :id and r.time between :t1 and :t2 order by r.time");
        q.setParameter("id", (Object)id);
        q.setParameter("t1", (Object)t1);
        q.setParameter("t2", (Object)t2);
        List l = q.list();
        log.debug((Object)("retrieved raw data " + id + "[" + t1 + "," + t2 + "] : " + l.size()));
        sess.close();
        return l;
    }

    protected List<StatData> getStatData(StatDesc statDesc, long t1, long t2) {
        Session sess = this.fac.openSession();
        Query q = sess.createQuery("from StatData r where r.statDesc.id = :id and r.statTimeInterval.startTime >= :t1 and r.statTimeInterval.startTime <= :t2 order by r.statTimeInterval.startTime");
        q.setParameter("id", (Object)statDesc.getId());
        q.setParameter("t1", (Object)(t1 - statDesc.getTimeBinWidth()));
        q.setParameter("t2", (Object)t2);
        List l = q.list();
        log.debug((Object)("retrieved stat data " + statDesc.getId() + "[" + t1 + "," + t2 + "] : " + l.size()));
        sess.close();
        return l;
    }

    protected Data exportRawData(long rawId, long t1, long t2) {
        List<RawData> l = this.getRawData(rawId, t1, t2);
        Data d = new Data();
        d.setMetaDataData(this.getMetadata((int)rawId, t1, t2));
        TrendingData[] data = new TrendingData[l.size()];
        for (int i = 0; i < l.size(); ++i) {
            TrendingData dt;
            RawData r = l.get(i);
            data[i] = dt = new TrendingData();
            long tStamp = r.getTime();
            TrendingData.AxisValue axisValue = new TrendingData.AxisValue("time", tStamp);
            dt.setAxisValue(axisValue);
            TrendingData.DataValue[] dataValue = new TrendingData.DataValue[1];
            Double dd = r.getDoubleData();
            dataValue[0] = new TrendingData.DataValue("value", dd == null ? 0.0 : dd);
            dt.setDataValue(dataValue);
        }
        d.getTrendingResult().setTrendingDataArray(data);
        return d;
    }

    protected Data exportStatDataFromRaw(long rawId, long t1, long t2, int nsamples) {
        Session sess = this.fac.openSession();
        SQLQuery q = sess.createSQLQuery("select tlow, thigh, datasum/entries as mean,  sqrt((datasumsquared - datasum*datasum/entries)/(entries-1)) as rms,  mindata, maxdata  from ( SELECT MIN(rd.time) AS tlow, MAX(rd.time) AS thigh,  SUM(rd.doubleData) AS datasum, SUM(rd.doubleData*rd.doubleData) AS datasumsquared,  min(rd.doubleData) as mindata, max(rd.doubleData) as maxdata,  count(1) AS entries from ccs_rawData rd where rd.dataDescId = :id and time >= :t1  and time <= :t2 group by floor(rd.time/:deltat) ) accumulated where entries > 0 ");
        long deltat = (t2 - t1) / (long)nsamples;
        q.setParameter("id", (Object)rawId);
        q.setParameter("t1", (Object)t1);
        q.setParameter("t2", (Object)t2);
        q.setParameter("deltat", (Object)deltat);
        List l = q.list();
        sess.close();
        ArrayList<TrendingData> trendingDataList = new ArrayList<TrendingData>();
        for (Object[] obj : l) {
            if (obj[2] == null) continue;
            long low = ((BigInteger)obj[0]).longValue();
            long high = ((BigInteger)obj[1]).longValue();
            TrendingData dt = new TrendingData();
            dt.setAxisValue(new TrendingData.AxisValue("time", (low + high) / 2L, low, high));
            TrendingData.DataValue[] dataValue = new TrendingData.DataValue[4];
            double value = (Double)obj[2];
            double rms = 0.0;
            if (obj[3] != null) {
                rms = (Double)obj[3];
            }
            double min = (Double)obj[4];
            double max = (Double)obj[5];
            dataValue[0] = new TrendingData.DataValue("value", value);
            dataValue[1] = new TrendingData.DataValue("rms", rms);
            dataValue[2] = new TrendingData.DataValue("min", min);
            dataValue[3] = new TrendingData.DataValue("max", max);
            dt.setDataValue(dataValue);
            trendingDataList.add(dt);
        }
        TrendingData[] trendingData = trendingDataList.toArray(new TrendingData[0]);
        Data d = new Data();
        d.setMetaDataData(this.getMetadata((int)rawId, t1, t2));
        d.getTrendingResult().setTrendingDataArray(trendingData);
        return d;
    }

    protected Data exportStatDataFromStat(StatDesc statDesc, long t1, long t2, int nsamples) {
        List<StatData> in = this.getStatData(statDesc, t1, t2);
        int n = in.size();
        int rebin = 1;
        int nout = n;
        if (n > nsamples * 3) {
            rebin = n / nsamples;
            nout = (n + rebin - 1) / rebin;
            log.debug((Object)("will rebin stat by " + rebin + " : " + nout));
        }
        Data d = new Data();
        d.setMetaDataData(this.getMetadata((int)statDesc.getDataDesc().getId(), t1, t2));
        d.getTrendingResult().setTrendingDataArray(new TrendingData[nout]);
        int iout = 0;
        int ibin = 0;
        double sum = 0.0;
        double s2 = 0.0;
        long nsamp = 0L;
        long low = 0L;
        double max = Double.MIN_NORMAL;
        double min = Double.MAX_VALUE;
        for (StatData sd : in) {
            if (ibin == 0) {
                sum = 0.0;
                s2 = 0.0;
                nsamp = 0L;
                low = sd.getStatTimeInterval().getStartTime();
                max = Double.MIN_NORMAL;
                min = Double.MAX_VALUE;
            }
            sum += sd.getSum();
            s2 += sd.getSum2();
            if (sd.getMax() > max) {
                max = sd.getMax();
            }
            if (sd.getMin() < min) {
                min = sd.getMin();
            }
            nsamp += (long)sd.getN();
            if (ibin == rebin - 1 || iout * rebin + ibin == n - 1) {
                TrendingData dt;
                log.debug((Object)("storing for " + iout + " from " + (ibin + 1) + " bins"));
                d.getTrendingResult().getTrendingDataArray()[iout] = dt = new TrendingData();
                dt.setAxisValue(new TrendingData.AxisValue("time", (low + sd.getStatTimeInterval().getEndTime()) / 2L, low, sd.getStatTimeInterval().getEndTime()));
                TrendingData.DataValue[] dataValue = new TrendingData.DataValue[]{new TrendingData.DataValue("value", sum / (double)nsamp), new TrendingData.DataValue("rms", s2 / (double)nsamp - sum / (double)nsamp * (sum / (double)nsamp)), new TrendingData.DataValue("min", min), new TrendingData.DataValue("max", max)};
                dt.setDataValue(dataValue);
                ++iout;
                ibin = 0;
                continue;
            }
            ++ibin;
        }
        return d;
    }

    public List<RaisedAlertData> getActiveAlerts(long id) {
        Session sess = this.fac.openSession();
        Query q = sess.createQuery("from RaisedAlertData arad where arad.alertDesc.alertId=:id and arad.active=true and arad.cleared=false").setString("id", String.valueOf(id));
        return q.list();
    }

    public static void main(String[] args) throws IOException {
        int socket = 8080;
        if (args.length > 0) {
            socket = Integer.decode(args[0]);
        }
        class MyApplication
        extends Application {
            MyApplication() {
            }

            public Set<Class<?>> getClasses() {
                HashSet s = new HashSet();
                s.add(DataServer.class);
                return s;
            }
        }
        MyApplication app = new MyApplication();
        HttpHandler h = (HttpHandler)RuntimeDelegate.getInstance().createEndpoint((Application)app, HttpHandler.class);
        HttpServer s = HttpServer.create(new InetSocketAddress(socket), 5);
        s.createContext("/rest/data/", h);
        s.start();
    }

    static {
        Log4JConfiguration.initialize();
        log = Logger.getLogger((String)"org.lsst.ccs.localdb");
    }

    @XmlRootElement(name="channelinfo")
    public static class ChannelMetadataList {
        @XmlElementWrapper(name="channelmetadata")
        @XmlElement(name="channelmetadatavalue")
        public List<ChannelMetaData> list;

        public ChannelMetadataList(List<ChannelMetaData> list) {
            this.list = list;
        }

        public ChannelMetadataList() {
        }
    }
}

