/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.application.mdi;

import java.awt.Component;
import javax.swing.Icon;
import javax.swing.event.EventListenerList;
import org.freehep.application.mdi.PageEvent;
import org.freehep.application.mdi.PageListener;
import org.freehep.application.mdi.PageManager;

public class PageContext {
    private final Component component;
    private PageManager pageManager;
    private EventListenerList listenerList;
    private final String type;
    private String title;
    private Icon icon;

    PageContext(Component component, String title, Icon icon, String type) {
        this.component = component;
        this.title = title;
        this.icon = icon;
        this.type = type;
    }

    void setPageManager(PageManager manager) {
        this.pageManager = manager;
    }

    PageManager getPageManager() {
        return this.pageManager;
    }

    public void addPageListener(PageListener listener) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.add(PageListener.class, listener);
    }

    public void removePageListener(PageListener listener) {
        this.listenerList.remove(PageListener.class, listener);
    }

    void firePageEvent(PageEvent event, int id) {
        if (this.listenerList != null) {
            Object[] listeners = this.listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != PageListener.class) continue;
                if (event == null) {
                    event = new PageEvent(this, id);
                }
                ((PageListener)listeners[i + 1]).pageChanged(event);
            }
        }
    }

    public void requestShow() {
        this.pageManager.show(this);
    }

    public void close() {
        this.pageManager.close(this);
    }

    public Component getPage() {
        return this.component;
    }

    public String getTitle() {
        return this.title;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public void setTitle(String title) {
        this.title = title;
        this.pageManager.titleChanged(this);
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
        this.pageManager.iconChanged(this);
    }

    public String toString() {
        return "PageContext: " + this.title;
    }

    public String type() {
        return this.type;
    }
}

