/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.application.mdi;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import org.freehep.application.Application;
import org.freehep.application.mdi.CloseButtonTabbedPane;
import org.freehep.application.mdi.PageContext;
import org.freehep.application.mdi.PageManager;
import org.freehep.swing.popup.GlobalMouseListener;
import org.freehep.swing.popup.GlobalPopupListener;
import org.freehep.swing.popup.HasPopupItems;
import org.freehep.util.commanddispatcher.CommandProcessor;
import org.freehep.util.commanddispatcher.CommandSource;
import org.freehep.util.commanddispatcher.CommandSourceAdapter;
import org.freehep.util.commanddispatcher.CommandState;
import org.freehep.util.commanddispatcher.CommandTargetManager;

public class DockPageManager
extends PageManager {
    protected HashMap<PageContext, PageFrame> frames;
    protected JTabbedPane tabs;
    private MouseListener ml;
    private boolean watchTabs;
    private int tabPlacement = 1;

    public DockPageManager() {
        this.setPageManagerType("Page");
    }

    @Override
    protected void setActive(boolean active) {
        if (active) {
            this.tabs = new CloseButtonTabbedPane(){

                @Override
                protected void fireCloseTabAt(int index) {
                    DockPageManager.this.close(DockPageManager.this.getContext(index));
                }

                @Override
                protected void fireUndockTabAt(int index, int x, int y) {
                    DockPageManager.this.undock(DockPageManager.this.getContext(index), x, y, false);
                }

                @Override
                public JPopupMenu modifyPopupMenu(JPopupMenu menu, Component source, Point p) {
                    return DockPageManager.this.modifyPopupMenu(menu, source, p);
                }
            };
            this.tabs.setTabPlacement(this.tabPlacement);
            this.ml = new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent e) {
                    if (!e.isPopupTrigger()) {
                        DockPageManager.this.selectTab();
                    }
                }
            };
            this.tabs.addMouseListener(this.ml);
            this.watchTabs = true;
            this.frames = new HashMap();
        } else {
            this.tabs.removeAll();
            this.tabs.removeMouseListener(this.ml);
            this.tabs = null;
            this.frames = null;
        }
    }

    @Override
    protected void init(List<PageContext> pages, PageContext selected) {
        super.init(pages, selected);
        this.watchTabs = false;
        for (PageContext context : pages) {
            this.tabs.addTab(this.hackedTitle(context.getTitle()), context.getIcon(), context.getPage());
            if (context != selected) continue;
            this.tabs.setSelectedComponent(context.getPage());
        }
        this.watchTabs = true;
        if (selected == null && pages.size() > 0) {
            this.fireSelectionChanged(this.pages().get(this.tabs.getSelectedIndex()));
        }
    }

    @Override
    public PageContext openPage(Component page, String title, Icon icon, String type, boolean selectOnOpen) {
        PageContext context = super.openPage(page, title, icon, type, selectOnOpen);
        this.tabs.addTab(this.hackedTitle(title), icon, page);
        this.firePageOpened(context);
        if (selectOnOpen) {
            this.tabs.setSelectedComponent(page);
            this.selectTab();
        }
        return context;
    }

    @Override
    protected boolean close(PageContext context) {
        boolean ok = super.close(context);
        if (ok) {
            PageFrame frame = this.frames.get(context);
            if (frame == null) {
                this.tabs.removeTabAt(this.getTab(context));
            } else {
                frame.setVisible(false);
                frame.dispose();
            }
            if (this.getSelectedPage() == null) {
                this.chooseSelection();
            }
        }
        return ok;
    }

    @Override
    protected void show(PageContext context) {
        PageFrame frame = this.frames.get(context);
        if (frame == null) {
            this.tabs.setSelectedComponent(context.getPage());
        } else {
            frame.setVisible(true);
            frame.toFront();
        }
    }

    @Override
    protected Component getEmbodiment() {
        return this.tabs;
    }

    private String hackedTitle(String title) {
        return title == null ? CloseButtonTabbedPane.TAB_NAME_TRAILING_SPACE : title + CloseButtonTabbedPane.TAB_NAME_TRAILING_SPACE;
    }

    @Override
    protected void titleChanged(PageContext context) {
        PageFrame frame = this.frames.get(context);
        if (frame == null) {
            this.tabs.setTitleAt(this.getTab(context), this.hackedTitle(context.getTitle()));
        } else {
            frame.setTitle(context.getTitle());
        }
    }

    @Override
    protected void iconChanged(PageContext context) {
        PageFrame frame = this.frames.get(context);
        if (frame == null) {
            this.tabs.setIconAt(this.getTab(context), context.getIcon());
        } else {
            try {
                frame.setIconImage(((ImageIcon)context.getIcon()).getImage());
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
    }

    public void setTabPlacement(int placement) {
        this.tabPlacement = placement;
        if (this.tabs != null) {
            this.tabs.setTabPlacement(placement);
        }
    }

    public int getTabPlacement() {
        return this.tabPlacement;
    }

    protected int getTab(PageContext context) {
        return this.tabs.indexOfComponent(context.getPage());
    }

    protected PageContext getContext(int tabIndex) {
        return this.getContext(this.tabs.getComponentAt(tabIndex));
    }

    protected void selectTab() {
        int index;
        if (this.watchTabs && (index = this.tabs.getSelectedIndex()) != -1) {
            this.fireSelectionChanged(this.getContext(index));
        }
    }

    protected void dock(PageContext context) {
        if (context == null) {
            return;
        }
        PageFrame frame = this.frames.remove(context);
        if (frame == null) {
            return;
        }
        frame.dispose();
        this.watchTabs = false;
        this.tabs.addTab(this.hackedTitle(context.getTitle()), context.getIcon(), context.getPage());
        if (context == this.getSelectedPage()) {
            this.tabs.setSelectedComponent(context.getPage());
        }
        this.watchTabs = true;
    }

    protected void undock(PageContext context, int x, int y, boolean maximized) {
        int tabIndex = this.getTab(context);
        if (tabIndex >= 0) {
            this.watchTabs = false;
            Dimension d = context.getPage().getSize();
            this.tabs.removeTabAt(tabIndex);
            this.tabs.repaint();
            this.watchTabs = true;
            PageFrame frame = new PageFrame(context);
            frame.add(context.getPage(), "Center");
            if (maximized) {
                frame.setExtendedState(frame.getExtendedState() | 6);
            } else {
                frame.setLocation(x, y);
            }
            context.getPage().setPreferredSize(d);
            frame.pack();
            this.frames.put(context, frame);
            frame.setVisible(true);
        }
    }

    protected void chooseSelection() {
        int index = this.tabs.getSelectedIndex();
        if (index >= 0) {
            this.fireSelectionChanged(this.getContext(index));
            return;
        }
        try {
            this.tabs.setSelectedIndex(0);
            return;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            for (PageFrame pf : this.frames.values()) {
                if ((pf.getExtendedState() & 1) != 0) continue;
                pf.toFront();
                return;
            }
            this.fireSelectionChanged(null);
            return;
        }
    }

    @Override
    protected JPopupMenu modifyPopupMenu(JPopupMenu menu, Component source, Point p) {
        JComponent dockMenu;
        int n = (menu = super.modifyPopupMenu(menu, source, p)).getComponentCount();
        if (n > 0) {
            Component last = menu.getComponent(n - 1);
            if (last instanceof JMenu) {
                dockMenu = new JMenu("Dock");
                menu.add(dockMenu);
            } else {
                dockMenu = menu;
                menu.addSeparator();
            }
        } else {
            dockMenu = menu;
        }
        CommandTargetManager cm = Application.getApplication().getCommandTargetManager();
        JMenuItem fullScreen = new JMenuItem("Full Screen");
        fullScreen.setActionCommand("fullScreen");
        cm.add((CommandSource)new CommandSourceAdapter((AbstractButton)fullScreen));
        dockMenu.add(fullScreen);
        JMenuItem dock = new JMenuItem("Dock");
        dock.setActionCommand("dock");
        cm.add((CommandSource)new CommandSourceAdapter((AbstractButton)dock));
        dockMenu.add(dock);
        JMenuItem dockAll = new JMenuItem("Dock All");
        dockAll.setActionCommand("dockAll");
        cm.add((CommandSource)new CommandSourceAdapter((AbstractButton)dockAll));
        dockMenu.add(dockAll);
        return menu;
    }

    @Override
    protected CommandProcessor createCommandProcessor() {
        return new PageManager.PageManagerCommandProcessor(){

            public void onFullScreen() {
                DockPageManager.this.undock(DockPageManager.this.getSelectedPage(), 0, 0, true);
            }

            public void enableFullScreen(CommandState state) {
                PageContext context = DockPageManager.this.getSelectedPage();
                state.setEnabled(context != null && DockPageManager.this.frames.get(context) == null);
            }

            public void onDock() {
                DockPageManager.this.dock(DockPageManager.this.getSelectedPage());
            }

            public void enableDock(CommandState state) {
                PageContext context = DockPageManager.this.getSelectedPage();
                state.setEnabled(context != null && DockPageManager.this.frames.get(context) != null);
            }

            public void onDockAll() {
                for (PageContext page : DockPageManager.this.pages()) {
                    DockPageManager.this.dock(page);
                }
            }

            public void enableDockAll(CommandState state) {
                state.setEnabled(!DockPageManager.this.frames.isEmpty());
            }
        };
    }

    protected class PageFrame
    extends JFrame
    implements HasPopupItems {
        private final PageContext context;
        private final WindowAdapter wl;

        PageFrame(PageContext pageContext) {
            super(pageContext.getTitle());
            this.wl = new WindowAdapter(){

                @Override
                public void windowActivated(WindowEvent e) {
                    DockPageManager.this.fireSelectionChanged(PageFrame.this.context);
                }

                @Override
                public void windowDeiconified(WindowEvent e) {
                    DockPageManager.this.fireSelectionChanged(PageFrame.this.context);
                }

                @Override
                public void windowIconified(WindowEvent e) {
                    DockPageManager.this.chooseSelection();
                }

                @Override
                public void windowClosing(WindowEvent e) {
                    DockPageManager.this.close(PageFrame.this.context);
                }
            };
            this.context = pageContext;
            this.setAutoRequestFocus(true);
            this.setDefaultCloseOperation(0);
        }

        public JPopupMenu modifyPopupMenu(JPopupMenu menu, Component source, Point p) {
            return DockPageManager.this.modifyPopupMenu(menu, source, p);
        }

        @Override
        public void setVisible(boolean b) {
            if (b) {
                this.addWindowListener(this.wl);
                GlobalMouseListener gml = new GlobalMouseListener((Component)this);
                gml.addMouseListener((MouseListener)new GlobalPopupListener());
            } else {
                this.removeWindowListener(this.wl);
            }
            super.setVisible(b);
        }
    }
}

