/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.trending;

import java.awt.Color;
import java.awt.Dimension;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.InputVerifier;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.CaretListener;
import org.freehep.application.Application;
import org.freehep.application.PropertyUtilities;
import org.freehep.application.studio.Studio;
import org.freehep.jas.services.PreferencesTopic;
import org.lsst.ccs.gconsole.plugins.trending.LsstTrendingPlugin;
import org.lsst.ccs.gconsole.plugins.trending.Trend;

public class TrendingPreferences
implements PreferencesTopic {
    private final LsstTrendingPlugin plugin;
    private final Studio app;
    private final String keyPrefix = "org.lsst.trending.";
    private final String autoStartKey = "autoStart";
    private final String autoSaveKey = "autoSave";
    private final String useRawDataKey = "rawData";
    private final String nBinsKey = "bins";
    private final String refreshMinKey = "refreshMin";
    private final String refreshMaxKey = "refreshMax";
    private final String warnOnAlarmKey = "warnOnAlarm";
    private final String drawMetaKey = "drawMeta";
    private final String doubleClickKey = "doubleClick";
    private final String dndKey = "dnd";
    private final boolean autoStartDefault = false;
    private final boolean autoSaveDefault = false;
    private final boolean useRawDataDefault = false;
    private final int nBinsDefault = 50;
    private final int refreshMinDefault = 10;
    private final int refreshMaxDefault = 3600;
    private final boolean warnOnAlarmDefault = false;
    private final EnumSet<Trend.Meta> drawMetaDefault = EnumSet.noneOf(Trend.Meta.class);
    private final int doubleClickDefault = -1;
    private final int dndDefault = 0;
    private boolean autoStart;
    private boolean autoSave;
    private boolean useRawData;
    private int nBins;
    private int refreshMin;
    private int refreshMax;
    private boolean warnOnAlarm;
    private EnumSet<Trend.Meta> drawMeta;
    private int doubleClick;
    private int dnd;

    public TrendingPreferences(LsstTrendingPlugin plugin) {
        this.plugin = plugin;
        this.app = (Studio)Application.getApplication();
        this.restore();
    }

    protected final void restore() {
        Properties prop = this.app.getUserProperties();
        this.autoStart = PropertyUtilities.getBoolean((Properties)prop, (String)"org.lsst.trending.autoStart", (boolean)false);
        this.autoSave = PropertyUtilities.getBoolean((Properties)prop, (String)"org.lsst.trending.autoSave", (boolean)false);
        this.useRawData = PropertyUtilities.getBoolean((Properties)prop, (String)"org.lsst.trending.rawData", (boolean)false);
        this.nBins = PropertyUtilities.getInteger((Properties)prop, (String)"org.lsst.trending.bins", (int)50);
        this.refreshMin = PropertyUtilities.getInteger((Properties)prop, (String)"org.lsst.trending.refreshMin", (int)10);
        this.refreshMax = PropertyUtilities.getInteger((Properties)prop, (String)"org.lsst.trending.refreshMax", (int)3600);
        this.warnOnAlarm = PropertyUtilities.getBoolean((Properties)prop, (String)"org.lsst.trending.warnOnAlarm", (boolean)false);
        String dm = PropertyUtilities.getString((Properties)prop, (String)"org.lsst.trending.drawMeta", (String)"");
        String[] ss = dm.split("\\+");
        this.drawMeta = EnumSet.noneOf(Trend.Meta.class);
        for (String s : ss) {
            try {
                this.drawMeta.add(Trend.Meta.valueOf(s));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        this.doubleClick = PropertyUtilities.getInteger((Properties)prop, (String)"org.lsst.trending.doubleClick", (int)-1);
        this.dnd = PropertyUtilities.getInteger((Properties)prop, (String)"org.lsst.trending.dnd", (int)0);
    }

    protected void save() {
        Properties prop = this.app.getUserProperties();
        PropertyUtilities.setBoolean((Properties)prop, (String)"org.lsst.trending.autoStart", !this.autoStart ? null : Boolean.valueOf(this.autoStart));
        PropertyUtilities.setBoolean((Properties)prop, (String)"org.lsst.trending.autoSave", !this.autoSave ? null : Boolean.valueOf(this.autoSave));
        PropertyUtilities.setBoolean((Properties)prop, (String)"org.lsst.trending.rawData", !this.useRawData ? null : Boolean.valueOf(this.useRawData));
        PropertyUtilities.setInteger((Properties)prop, (String)"org.lsst.trending.bins", this.nBins == 50 ? null : Integer.valueOf(this.nBins));
        PropertyUtilities.setInteger((Properties)prop, (String)"org.lsst.trending.refreshMin", this.refreshMin == 10 ? null : Integer.valueOf(this.refreshMin));
        PropertyUtilities.setInteger((Properties)prop, (String)"org.lsst.trending.refreshMax", this.refreshMax == 3600 ? null : Integer.valueOf(this.refreshMax));
        PropertyUtilities.setBoolean((Properties)prop, (String)"org.lsst.trending.warnOnAlarm", !this.warnOnAlarm ? null : Boolean.valueOf(this.warnOnAlarm));
        if (this.drawMeta.equals(this.drawMetaDefault)) {
            PropertyUtilities.setString((Properties)prop, (String)("org.lsst.trending." + this.drawMeta), null);
        } else {
            StringBuilder sb = new StringBuilder();
            this.drawMeta.forEach(m -> sb.append(m).append("+"));
            PropertyUtilities.setString((Properties)prop, (String)"org.lsst.trending.drawMeta", (String)sb.substring(0, sb.length() - 1));
        }
        PropertyUtilities.setInteger((Properties)prop, (String)"org.lsst.trending.doubleClick", this.doubleClick == -1 ? null : Integer.valueOf(this.doubleClick));
        PropertyUtilities.setInteger((Properties)prop, (String)"org.lsst.trending.dnd", this.dnd == 0 ? null : Integer.valueOf(this.dnd));
    }

    public boolean isAutoStart() {
        return this.autoStart;
    }

    public boolean isAutoSave() {
        return this.autoSave;
    }

    public boolean isUseRawData() {
        return this.useRawData;
    }

    public int getNBins() {
        return this.nBins;
    }

    public int getRefreshMin() {
        return this.refreshMin;
    }

    public int getRefreshMax() {
        return this.refreshMax;
    }

    public boolean isWarnOnAlarm() {
        return this.warnOnAlarm;
    }

    public EnumSet<Trend.Meta> getDrawMeta() {
        return this.drawMeta;
    }

    public int getDoubleClick() {
        return this.doubleClick;
    }

    public int getDnd() {
        return this.dnd;
    }

    public void setAutoStart(boolean autoStart, boolean save) {
        this.autoStart = autoStart;
        if (save) {
            PropertyUtilities.setBoolean((Properties)this.app.getUserProperties(), (String)"org.lsst.trending.autoStart", (Boolean)(!autoStart ? null : Boolean.valueOf(autoStart)));
        }
    }

    public void setAutoSave(boolean autoSave, boolean save) {
        this.autoSave = autoSave;
        if (save) {
            PropertyUtilities.setBoolean((Properties)this.app.getUserProperties(), (String)"org.lsst.trending.autoSave", (Boolean)(!autoSave ? null : Boolean.valueOf(autoSave)));
        }
    }

    public void setUseRawData(boolean useRawData, boolean save) {
        this.useRawData = useRawData;
        if (save) {
            PropertyUtilities.setBoolean((Properties)this.app.getUserProperties(), (String)"org.lsst.trending.rawData", (Boolean)(!useRawData ? null : Boolean.valueOf(useRawData)));
        }
    }

    public void setNBins(int nBins, boolean save) {
        this.nBins = nBins;
        if (save) {
            PropertyUtilities.setInteger((Properties)this.app.getUserProperties(), (String)"org.lsst.trending.bins", (Integer)(nBins == 50 ? null : Integer.valueOf(nBins)));
        }
    }

    public void setRefresh(int refreshMin, int refreshMax, boolean save) {
        this.refreshMin = refreshMin;
        this.refreshMax = refreshMax;
        if (save) {
            PropertyUtilities.setInteger((Properties)this.app.getUserProperties(), (String)"org.lsst.trending.refreshMin", (Integer)(refreshMin == 10 ? null : Integer.valueOf(refreshMin)));
            PropertyUtilities.setInteger((Properties)this.app.getUserProperties(), (String)"org.lsst.trending.refreshMax", (Integer)(refreshMax == 3600 ? null : Integer.valueOf(refreshMax)));
        }
    }

    public void setWarnOnAlarm(boolean warnOnAlarm, boolean save) {
        this.warnOnAlarm = warnOnAlarm;
        if (save) {
            PropertyUtilities.setBoolean((Properties)this.app.getUserProperties(), (String)"org.lsst.trending.warnOnAlarm", (Boolean)(!warnOnAlarm ? null : Boolean.valueOf(warnOnAlarm)));
        }
    }

    public void setDrawMeta(EnumSet<Trend.Meta> drawMeta, boolean save) {
        this.drawMeta = drawMeta;
        if (save) {
            if (drawMeta.equals(this.drawMetaDefault)) {
                PropertyUtilities.setString((Properties)this.app.getUserProperties(), (String)"org.lsst.trending.drawMeta", null);
            } else {
                StringBuilder sb = new StringBuilder();
                drawMeta.forEach(m -> sb.append(m).append("+"));
                PropertyUtilities.setString((Properties)this.app.getUserProperties(), (String)"org.lsst.trending.drawMeta", (String)sb.substring(0, sb.length() - 1));
            }
        }
    }

    public void setDoubleClick(int doubleClick, boolean save) {
        this.doubleClick = doubleClick;
        if (save) {
            PropertyUtilities.setInteger((Properties)this.app.getUserProperties(), (String)"org.lsst.trending.doubleClick", (Integer)(doubleClick == -1 ? null : Integer.valueOf(doubleClick)));
        }
    }

    public void setDnd(int dnd, boolean save) {
        this.dnd = dnd;
        if (save) {
            PropertyUtilities.setInteger((Properties)this.app.getUserProperties(), (String)"org.lsst.trending.dnd", (Integer)(dnd == 0 ? null : Integer.valueOf(dnd)));
        }
    }

    public String[] path() {
        return new String[]{"LSST", "Trending"};
    }

    public JComponent component() {
        return new GUI();
    }

    public boolean apply(JComponent gui) {
        try {
            boolean out = ((GUI)gui).get();
            if (out) {
                this.save();
            }
            return out;
        }
        catch (ClassCastException x) {
            return false;
        }
    }

    private class GUI
    extends JPanel {
        private final int HSPACE = 10;
        private final int VSPACE = 5;
        JCheckBox _autoStartBox;
        JCheckBox _autoSaveBox;
        JRadioButton _useRawDataRadio;
        JRadioButton _useStatDataRadio;
        ButtonGroup _dataButtonGroup;
        JCheckBox _nBinsBox;
        JTextField _nBinsField;
        String[] _doubleClickOptions = new String[]{"Show", "Plot", "New Plot", "New Page"};
        JRadioButton[] _doubleClickRadio;
        ButtonGroup _doubleClickGroup;
        String[] _dndOptions = new String[]{"Replace", "Overlay"};
        JRadioButton[] _dndRadio;
        ButtonGroup _dndGroup;
        JCheckBox _warnOnAlarmBox;
        EnumMap<Trend.Meta, JCheckBox> _drawMetaBox = new EnumMap(Trend.Meta.class);
        JCheckBox selectedMetaBox;
        JRadioButton _refreshFixedRadio;
        JRadioButton _refreshAdaptiveRadio;
        ButtonGroup _refreshGroup;
        JTextField _refreshFixedField;
        JTextField _refreshMinField;
        JTextField _refreshMaxField;
        InputVerifier standardVerifier = new InputVerifier(){

            @Override
            public boolean verify(JComponent input) {
                return input.getForeground().equals(Color.BLACK);
            }
        };

        GUI() {
            int i;
            this.setLayout(new BoxLayout(this, 1));
            Box panel = Box.createVerticalBox();
            panel.setBorder(BorderFactory.createTitledBorder("Startup"));
            panel.setAlignmentX(0.0f);
            Box row = Box.createHorizontalBox();
            row.setAlignmentX(0.0f);
            this._autoStartBox = new JCheckBox("Start trending on startup.");
            row.add(this._autoStartBox);
            row.add(Box.createHorizontalGlue());
            panel.add(row);
            row = Box.createHorizontalBox();
            row.setAlignmentX(0.0f);
            this._autoSaveBox = new JCheckBox("Restore configuration on startup.");
            row.add(this._autoSaveBox);
            row.add(Box.createHorizontalGlue());
            panel.add(row);
            this.add(panel);
            this.add(Box.createRigidArea(new Dimension(0, 5)));
            panel = Box.createVerticalBox();
            panel.setBorder(BorderFactory.createTitledBorder("Plotting"));
            panel.setAlignmentX(0.0f);
            row = Box.createHorizontalBox();
            row.setAlignmentX(0.0f);
            row.add(new JLabel("Double-click action: "));
            row.add(Box.createHorizontalGlue());
            panel.add(row);
            this._doubleClickRadio = new JRadioButton[this._doubleClickOptions.length];
            this._doubleClickGroup = new ButtonGroup();
            row = Box.createHorizontalBox();
            row.setAlignmentX(0.0f);
            for (i = 0; i < this._doubleClickOptions.length; ++i) {
                this._doubleClickRadio[i] = new JRadioButton(this._doubleClickOptions[i]);
                this._doubleClickGroup.add(this._doubleClickRadio[i]);
                row.add(this._doubleClickRadio[i]);
            }
            row.add(Box.createHorizontalGlue());
            panel.add(row);
            panel.add(Box.createRigidArea(new Dimension(0, 5)));
            row = Box.createHorizontalBox();
            row.setAlignmentX(0.0f);
            row.add(new JLabel("Drag-And-Drop action: "));
            row.add(Box.createHorizontalGlue());
            panel.add(row);
            this._dndRadio = new JRadioButton[this._dndOptions.length];
            this._dndGroup = new ButtonGroup();
            row = Box.createHorizontalBox();
            row.setAlignmentX(0.0f);
            for (i = 0; i < this._dndOptions.length; ++i) {
                this._dndRadio[i] = new JRadioButton(this._dndOptions[i]);
                this._dndGroup.add(this._dndRadio[i]);
                row.add(this._dndRadio[i]);
            }
            row.add(Box.createHorizontalGlue());
            panel.add(row);
            panel.add(Box.createRigidArea(new Dimension(0, 5)));
            Box metaPanel = Box.createVerticalBox();
            metaPanel.setBorder(BorderFactory.createTitledBorder("Show metadata:"));
            metaPanel.setAlignmentX(0.0f);
            ButtonGroup bg = new ButtonGroup();
            bg.add(new JCheckBox());
            for (Trend.Meta m : Trend.Meta.values()) {
                JCheckBox cb = new JCheckBox(m.toString());
                if (m.isOnPoint()) {
                    bg.add(cb);
                    cb.addActionListener(e -> {
                        if (cb == this.selectedMetaBox) {
                            this.selectedMetaBox = null;
                            bg.clearSelection();
                        } else {
                            this.selectedMetaBox = cb;
                        }
                    });
                }
                this._drawMetaBox.put(m, cb);
                row = Box.createHorizontalBox();
                row.setAlignmentX(0.0f);
                row.add(cb);
                row.add(Box.createHorizontalGlue());
                metaPanel.add(row);
            }
            panel.add(metaPanel);
            row = Box.createHorizontalBox();
            row.setAlignmentX(0.0f);
            this._warnOnAlarmBox = new JCheckBox("Scan for plots with alarms");
            row.add(this._warnOnAlarmBox);
            row.add(Box.createHorizontalGlue());
            this.add(panel);
            this.add(Box.createRigidArea(new Dimension(0, 5)));
            panel = Box.createVerticalBox();
            panel.setBorder(BorderFactory.createTitledBorder("Data"));
            panel.setAlignmentX(0.0f);
            row = Box.createHorizontalBox();
            row.setAlignmentX(0.0f);
            row.add(new JLabel("Data type: "));
            this._dataButtonGroup = new ButtonGroup();
            this._useRawDataRadio = new JRadioButton("Raw");
            this._dataButtonGroup.add(this._useRawDataRadio);
            row.add(this._useRawDataRadio);
            this._useStatDataRadio = new JRadioButton("Statistical");
            this._dataButtonGroup.add(this._useStatDataRadio);
            row.add(this._useStatDataRadio);
            row.add(Box.createHorizontalGlue());
            panel.add(row);
            row = Box.createHorizontalBox();
            row.setAlignmentX(0.0f);
            this._nBinsBox = new JCheckBox("Reduce to");
            this._nBinsBox.addActionListener(e -> {
                if (this._nBinsBox.isSelected()) {
                    this._nBinsField.setEnabled(true);
                    this._nBinsField.setText(Integer.toString(50));
                } else {
                    this._nBinsField.setEnabled(false);
                    this._nBinsField.setText("");
                }
            });
            row.add(this._nBinsBox);
            this._nBinsField = new JTextField(3);
            this._nBinsField.setMaximumSize(new Dimension(this._nBinsField.getPreferredSize().width, this._nBinsField.getPreferredSize().height));
            this._nBinsField.addCaretListener(e -> {
                String text = this._nBinsField.getText().trim();
                boolean valid = true;
                if (!text.isEmpty()) {
                    try {
                        int value = Integer.parseInt(text);
                        valid = value > 0;
                    }
                    catch (NumberFormatException x) {
                        valid = false;
                    }
                }
                this._nBinsField.setForeground(valid ? Color.BLACK : Color.RED);
            });
            this._nBinsField.setInputVerifier(this.standardVerifier);
            row.add(this._nBinsField);
            row.add(new JLabel(" bins if possible"));
            row.add(Box.createHorizontalGlue());
            panel.add(row);
            this.add(panel);
            this.add(Box.createRigidArea(new Dimension(0, 5)));
            panel = Box.createVerticalBox();
            panel.setBorder(BorderFactory.createTitledBorder("Auto Refresh Interval"));
            panel.setAlignmentX(0.0f);
            row = Box.createHorizontalBox();
            row.setAlignmentX(0.0f);
            this._refreshGroup = new ButtonGroup();
            this._refreshFixedRadio = new JRadioButton("Fixed: ");
            this._refreshGroup.add(this._refreshFixedRadio);
            this._refreshFixedRadio.addActionListener(e -> {
                if (this._refreshFixedRadio.isSelected()) {
                    this._refreshFixedField.setEnabled(true);
                    this._refreshMinField.setEnabled(false);
                    this._refreshMaxField.setEnabled(false);
                }
            });
            row.add(this._refreshFixedRadio);
            this._refreshFixedField = new JTextField(10);
            this._refreshFixedField.setMaximumSize(new Dimension(this._refreshFixedField.getPreferredSize().width, this._refreshFixedField.getPreferredSize().height));
            this._refreshFixedField.addCaretListener(e -> {
                boolean valid;
                String text = this._refreshFixedField.getText().trim();
                try {
                    int value = Integer.parseInt(text);
                    valid = value > 0;
                }
                catch (NumberFormatException x) {
                    valid = false;
                }
                this._refreshFixedField.setForeground(valid ? Color.BLACK : Color.RED);
            });
            this._refreshFixedField.setInputVerifier(this.standardVerifier);
            row.add(this._refreshFixedField);
            row.add(new JLabel(" seconds"));
            row.add(Box.createHorizontalGlue());
            panel.add(row);
            row = Box.createHorizontalBox();
            row.setAlignmentX(0.0f);
            this._refreshAdaptiveRadio = new JRadioButton("Adaptive: ");
            this._refreshGroup.add(this._refreshAdaptiveRadio);
            this._refreshAdaptiveRadio.addActionListener(e -> {
                if (this._refreshAdaptiveRadio.isSelected()) {
                    this._refreshFixedField.setEnabled(false);
                    this._refreshMinField.setEnabled(true);
                    this._refreshMaxField.setEnabled(true);
                }
            });
            row.add(this._refreshAdaptiveRadio);
            row.add(Box.createHorizontalGlue());
            panel.add(row);
            row = Box.createHorizontalBox();
            row.setAlignmentX(0.0f);
            row.add(new JLabel("     Minimum "));
            this._refreshMinField = new JTextField(6);
            this._refreshMinField.setMaximumSize(new Dimension(this._refreshMinField.getPreferredSize().width, this._refreshMinField.getPreferredSize().height));
            row.add(this._refreshMinField);
            row.add(new JLabel(" seconds"));
            row.add(Box.createHorizontalGlue());
            panel.add(row);
            row = Box.createHorizontalBox();
            row.setAlignmentX(0.0f);
            row.add(new JLabel("     Maximum "));
            this._refreshMaxField = new JTextField(6);
            this._refreshMaxField.setMaximumSize(new Dimension(this._refreshMaxField.getPreferredSize().width, this._refreshMaxField.getPreferredSize().height));
            row.add(this._refreshMaxField);
            row.add(new JLabel(" seconds"));
            row.add(Box.createHorizontalGlue());
            panel.add(row);
            CaretListener minMaxListener = e -> {
                int min = this.getInt(this._refreshMinField);
                if (min < 0) {
                    this._refreshMinField.setForeground(min == -2 ? Color.RED : Color.BLACK);
                    int max = this.getInt(this._refreshMaxField);
                    this._refreshMaxField.setForeground(max == -2 ? Color.RED : Color.BLACK);
                } else {
                    int max = this.getInt(this._refreshMaxField);
                    if (max < 0) {
                        this._refreshMinField.setForeground(Color.BLACK);
                        this._refreshMaxField.setForeground(max == -2 ? Color.RED : Color.BLACK);
                    } else {
                        Color color = min < max ? Color.BLACK : Color.RED;
                        this._refreshMinField.setForeground(color);
                        this._refreshMaxField.setForeground(color);
                    }
                }
            };
            this._refreshMinField.addCaretListener(minMaxListener);
            this._refreshMaxField.addCaretListener(minMaxListener);
            this.add(panel);
            this.add(Box.createVerticalGlue());
            this.set();
        }

        final boolean get() {
            int refreshMax;
            int refreshMin;
            boolean autoStart = this._autoStartBox.isSelected();
            boolean autoSave = this._autoSaveBox.isSelected();
            boolean useRawData = this._useRawDataRadio.isSelected();
            int nBins = 0;
            if (this._nBinsBox.isSelected()) {
                try {
                    nBins = Integer.parseInt(this._nBinsField.getText());
                    if (nBins < 1) {
                        return false;
                    }
                }
                catch (NumberFormatException x) {
                    return false;
                }
            }
            int doubleClick = -1;
            ButtonModel bm = this._doubleClickGroup.getSelection();
            for (int i = 0; i < this._doubleClickRadio.length; ++i) {
                if (!this._doubleClickRadio[i].getModel().equals(bm)) continue;
                doubleClick = -1 - i;
            }
            int dnd = 0;
            bm = this._dndGroup.getSelection();
            for (int i = 0; i < this._dndRadio.length; ++i) {
                if (!this._dndRadio[i].getModel().equals(bm)) continue;
                dnd = i;
            }
            boolean warnOnAlarm = this._warnOnAlarmBox.isSelected();
            EnumSet<Trend.Meta> drawMeta = EnumSet.noneOf(Trend.Meta.class);
            for (Trend.Meta m : Trend.Meta.values()) {
                if (!this._drawMetaBox.get((Object)m).isSelected()) continue;
                drawMeta.add(m);
            }
            if (this._refreshFixedRadio.isSelected()) {
                try {
                    refreshMin = Integer.parseInt(this._refreshFixedField.getText());
                    if (refreshMin < 1) {
                        return false;
                    }
                    refreshMax = refreshMin;
                }
                catch (NumberFormatException x) {
                    return false;
                }
            } else {
                refreshMin = this.getInt(this._refreshMinField);
                if (refreshMin == -2) {
                    return false;
                }
                if (refreshMin == -1) {
                    refreshMin = 0;
                }
                if ((refreshMax = this.getInt(this._refreshMaxField)) == -2) {
                    return false;
                }
                if (refreshMax == -1) {
                    refreshMax = Integer.MAX_VALUE;
                }
                if (refreshMin >= refreshMax) {
                    return false;
                }
            }
            TrendingPreferences.this.setAutoStart(autoStart, false);
            TrendingPreferences.this.setAutoSave(autoSave, false);
            TrendingPreferences.this.setDoubleClick(doubleClick, false);
            TrendingPreferences.this.setDnd(dnd, false);
            TrendingPreferences.this.setUseRawData(useRawData, false);
            TrendingPreferences.this.setNBins(nBins, false);
            TrendingPreferences.this.setRefresh(refreshMin, refreshMax, false);
            TrendingPreferences.this.setWarnOnAlarm(warnOnAlarm, false);
            TrendingPreferences.this.setDrawMeta(drawMeta, false);
            return true;
        }

        final void set() {
            boolean fixedRefreshRate;
            this._autoStartBox.setSelected(TrendingPreferences.this.autoStart);
            this._autoSaveBox.setSelected(TrendingPreferences.this.autoSave);
            this._useRawDataRadio.setSelected(TrendingPreferences.this.useRawData);
            this._useStatDataRadio.setSelected(!TrendingPreferences.this.useRawData);
            this._nBinsBox.setSelected(TrendingPreferences.this.nBins > 0);
            if (TrendingPreferences.this.nBins > 0) {
                this._nBinsField.setText(Integer.toString(TrendingPreferences.this.nBins));
            }
            try {
                this._doubleClickRadio[-TrendingPreferences.this.doubleClick - 1].setSelected(true);
            }
            catch (IndexOutOfBoundsException x) {
                this._doubleClickRadio[0].setSelected(true);
            }
            try {
                this._dndRadio[TrendingPreferences.this.dnd].setSelected(true);
            }
            catch (IndexOutOfBoundsException x) {
                this._dndRadio[0].setSelected(true);
            }
            this._warnOnAlarmBox.setSelected(TrendingPreferences.this.warnOnAlarm);
            for (Trend.Meta m : Trend.Meta.values()) {
                if (!TrendingPreferences.this.drawMeta.contains((Object)m)) continue;
                JCheckBox cb = this._drawMetaBox.get((Object)m);
                cb.setSelected(true);
                this.selectedMetaBox = cb;
            }
            boolean bl = fixedRefreshRate = TrendingPreferences.this.refreshMin == TrendingPreferences.this.refreshMax;
            if (fixedRefreshRate) {
                this._refreshFixedRadio.setSelected(true);
                this._refreshFixedField.setText(Integer.toString(TrendingPreferences.this.refreshMin));
                this._refreshFixedField.setEnabled(true);
                this._refreshMinField.setEnabled(false);
                this._refreshMaxField.setEnabled(false);
            } else {
                this._refreshAdaptiveRadio.setSelected(true);
                this._refreshMinField.setText(TrendingPreferences.this.refreshMin == 0 ? "" : Integer.toString(TrendingPreferences.this.refreshMin));
                this._refreshMaxField.setText(TrendingPreferences.this.refreshMax == Integer.MAX_VALUE ? "" : Integer.toString(TrendingPreferences.this.refreshMax));
                this._refreshFixedField.setEnabled(false);
                this._refreshMinField.setEnabled(true);
                this._refreshMaxField.setEnabled(true);
            }
        }

        private int getInt(JTextField field) {
            String text = field.getText().trim();
            if (text.isEmpty()) {
                return -1;
            }
            try {
                int out = Integer.parseInt(text);
                return out < 0 ? -2 : out;
            }
            catch (NumberFormatException x) {
                return -2;
            }
        }
    }
}

