package org.lsst.ccs.gconsole.plugins.trending;

import java.util.Map;

/**
 * Time history data for a specific channel and a specific time window.
 * The data includes all metadata available for .
 *
 * @author onoprien
 */
public class TrendData {
    
// -- Fields : -----------------------------------------------------------------
    
    private final Map<String, long[]> times;
    private final Map<String, double[]> values;
    
// -- Life cycle : -------------------------------------------------------------
    
    public TrendData(Map<String, long[]> times, Map<String, double[]> values) {
       this.times = times;
        this.values = values;
    }
    
// -- Getters : ----------------------------------------------------------------
    
    /**
     * Returns an array of time values for points in this history.
     * @return An array of times, in milliseconds.
     */
    public long[] getTime() {
        return times.get("value");
    }
    
    /**
     * Returns an array of values for points in this history.
     * @return An array of values.
     */
    public double[] getValue() {
        return values.get("value");
    }

    /**
     * Returns an array of time points available in this time history for the specified metadata type.
     * 
     * @param key String that identifies the metadata.
     * @return An array of times, in milliseconds.
     */
    public long[] getTime(String key) {
        return times.get(key);
    }
    
    /**
     * Returns an array of values contained in this time history for the specified metadata type.
     * 
     * @param key String that identifies the metadata.
     * @return An array of values for the specified data.
     */
    public double[] getValue(String key) {
        return values.get(key);
    }
    
    public long getLowT() {
        long[] time = getTime();
        if (time == null || time.length == 0) {
            return 0L;
        } else {
            return time[0];
        }
    }
    
    public long getHighT() {
        long[] time = getTime();
        if (time == null || time.length == 0) {
            return 0L;
        } else {
            return time[time.length - 1];
        }
    }
    
}
