/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.jas3;

import java.io.IOException;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.lsst.ccs.gconsole.Plugin;

@SupportedAnnotationTypes(value={"org.lsst.ccs.gconsole.Plugin"})
public class PluginDescriptorGenerator
extends AbstractProcessor {
    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        Document document = null;
        for (Element element : roundEnv.getElementsAnnotatedWith(Plugin.class)) {
            org.dom4j.Element pe;
            if (!(element.getKind() == ElementKind.CLASS && this.processingEnv.getTypeUtils().isAssignable(element.asType(), this.processingEnv.getElementUtils().getTypeElement("org.lsst.ccs.gconsole.ConsolePlugin").asType()) || element.getEnclosingElement().getKind() != ElementKind.PACKAGE)) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Invalid plugin: " + element + ". Only top-level non-abstract subclasses of ConsolePlugin can be annotated with @Plugin.");
                return true;
            }
            TypeElement te = (TypeElement)element;
            Plugin ann = element.getAnnotation(Plugin.class);
            String name = ann.name();
            if (name.isEmpty()) {
                name = te.getSimpleName().toString();
            }
            String author = ann.author();
            String version = ann.version();
            String category = ann.category();
            String shortDescription = ann.shortDescription();
            String description = ann.description();
            boolean loadAtStart = ann.loadAtStart();
            if (document == null) {
                document = DocumentHelper.createDocument();
                pe = document.addElement("plugins");
            } else {
                pe = document.getRootElement();
            }
            pe = pe.addElement("plugin");
            org.dom4j.Element xe = pe.addElement("information");
            xe.addElement("name").addText(name);
            xe.addElement("author").addText(author);
            xe.addElement("version").addText(version);
            xe.addElement("category").addText(category);
            xe.addElement("description").addAttribute("kind", "short").addText(shortDescription);
            xe.addElement("description").addText(description);
            if (loadAtStart) {
                xe.addElement("load-at-start");
            }
            pe.addElement("plugin-desc").addAttribute("class", te.getQualifiedName().toString());
        }
        if (document != null) {
            try {
                FileObject fo = this.processingEnv.getFiler().createResource(StandardLocation.SOURCE_OUTPUT, "", "PLUGIN-inf/plugins.xml", new Element[0]);
                OutputFormat outputFormat = OutputFormat.createPrettyPrint();
                XMLWriter writer = new XMLWriter(fo.openOutputStream(), outputFormat);
                writer.write(document);
            }
            catch (IOException x) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Error eriting plugin descriptor file: " + x);
            }
        }
        return true;
    }
}

