/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.tracer;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.freehep.jas.plugin.console.Console;
import org.freehep.jas.plugin.console.ConsoleService;
import org.lsst.ccs.gconsole.ConsolePlugin;
import org.lsst.ccs.gconsole.Plugin;
import org.lsst.ccs.gconsole.plugins.tracer.FilterChooser;
import org.lsst.ccs.gconsole.plugins.tracer.FilterRegistry;
import org.lsst.ccs.gconsole.plugins.tracer.MessageFilter;
import org.lsst.ccs.gconsole.plugins.tracer.Tracer;
import org.lsst.ccs.gconsole.plugins.tracer.TracerWriter;

@Plugin(name="LSST Tracer Plugin", description="LSST CCS alert notification service.")
public class LsstTracerPlugin
extends ConsolePlugin {
    private final String defaultTracerName = "Tracer";
    private final FilterRegistry filterRegistry = new FilterRegistry(this);
    private final Action newTracerAction = new AbstractAction("Raw"){

        @Override
        public void actionPerformed(ActionEvent e) {
            LsstTracerPlugin.this.createTracer("Tracer");
        }
    };
    private final Action formattedTracerAction = new AbstractAction("Formatted"){

        @Override
        public void actionPerformed(ActionEvent e) {
            LsstTracerPlugin.this.createTracer("Formatted tracer", LsstTracerPlugin.this.filterRegistry.getFilter("BuiltIn/Format/Standard"));
        }
    };
    private final Action filteredTracerAction = new AbstractAction("Filtered..."){

        @Override
        public void actionPerformed(ActionEvent e) {
            String filterName = FilterChooser.showDialog(LsstTracerPlugin.this.getConsole().getWindow(), LsstTracerPlugin.this.filterRegistry);
            if (filterName != null) {
                int i = filterName.lastIndexOf("/");
                LsstTracerPlugin.this.createTracer(filterName.substring(i + 1), LsstTracerPlugin.this.filterRegistry.getFilter(filterName));
            }
        }
    };

    @Override
    public void initialize() {
        this.getServices().addMenu(this.newTracerAction, "400: CCS Tools :-1:2", "Tracers:1");
        this.getServices().addMenu(this.formattedTracerAction, "400: CCS Tools :-1:2", "Tracers:2");
        this.getServices().addMenu(this.filteredTracerAction, "400: CCS Tools :-1:2", "Tracers:3");
    }

    @Override
    public void start() {
        this.filterRegistry.init();
    }

    public FilterRegistry getFilterRegistry() {
        return this.filterRegistry;
    }

    public Tracer createTracer(String name) {
        return this.createTracer(name, (MessageFilter)null);
    }

    public Tracer createTracer(String name, String filterName) {
        return this.createTracer(name, this.filterRegistry.getFilter(filterName));
    }

    public Tracer createTracer(String name, MessageFilter filter) {
        ConsoleService cs = (ConsoleService)this.getConsole().getLookup().lookup(ConsoleService.class);
        Tracer tracer = null;
        if (cs != null) {
            tracer = new Tracer(this, filter);
            Console console = cs.createConsole(name, null, tracer);
            TracerWriter pw = new TracerWriter(console);
            cs.getPageContextForConsole(console).addPageListener(tracer);
            tracer.start(pw);
        }
        return tracer;
    }
}

