/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.scripting.jython;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.List;
import java.util.Properties;
import org.freehep.util.ClasspathUtilities;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.utilities.pattern.PatternUtils;
import org.python.core.PyCode;
import org.python.core.PySystemState;
import org.python.util.PythonInterpreter;

public class JythonScriptExecutorUtils {
    public static InputStream getScriptInputStream(String script) throws FileNotFoundException {
        InputStream is = BootstrapResourceUtils.getBootstrapResource((String)script);
        if (is == null) {
            is = new FileInputStream(script);
        }
        return is;
    }

    public static void executeScript(String scriptPath, String ... args) throws IOException {
        InputStream is = JythonScriptExecutorUtils.getScriptInputStream(scriptPath);
        JythonScriptExecutorUtils.executeScript(is, args);
    }

    public static void executeScript(String scriptPath, OutputStream out, String ... args) throws IOException {
        InputStream is = JythonScriptExecutorUtils.getScriptInputStream(scriptPath);
        JythonScriptExecutorUtils.executeScript(is, out, args);
    }

    public static void executeScript(InputStream is, String ... args) throws IOException {
        JythonScriptExecutorUtils.executeScript(is, (OutputStream)System.out, args);
    }

    public static void executeScript(InputStream is, OutputStream out, String ... args) throws IOException {
        String line;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(is));
        StringBuilder stringBuffer = new StringBuilder();
        while ((line = bufferedReader.readLine()) != null) {
            stringBuffer.append(line).append("\n");
        }
        JythonScriptExecutorUtils.loadPythonSystemProperties();
        PySystemState state = new PySystemState();
        PythonInterpreter pyInterpreter = new PythonInterpreter(null, state);
        pyInterpreter.exec(JythonScriptExecutorUtils.getArgumentSettingCode(args));
        pyInterpreter.setOut(out);
        pyInterpreter.setErr(out);
        try {
            PyCode code = pyInterpreter.compile(stringBuffer.toString());
            pyInterpreter.exec(code);
        }
        catch (Exception executionException) {
            throw new RuntimeException(executionException);
        }
    }

    public static void loadPythonSystemProperties() {
        Properties sysProps = System.getProperties();
        sysProps.setProperty("python.packages.paths", "full.java.class.path,sun.boot.class.path,app.class.path");
        sysProps.setProperty("python.cachedir", PatternUtils.resolvePattern((String)BootstrapResourceUtils.getBootstrapSystemProperties().getProperty("org.lsst.ccs.console.jython.cachedir", "%W/cachedir")));
        if (sysProps.getProperty("python.verbose", "").isEmpty()) {
            sysProps.setProperty("python.verbose", "warning");
        }
        List bootstrapDirs = BootstrapResourceUtils.getOrderedListOfResourceDirectories();
        String pathSeparator = System.getProperty("path.separator");
        String pythonPath = "";
        for (String bootstrapDir : bootstrapDirs) {
            if (!pythonPath.isEmpty()) {
                pythonPath = pythonPath + pathSeparator;
            }
            pythonPath = pythonPath + bootstrapDir;
        }
        sysProps.setProperty("python.path", pythonPath);
        ClasspathUtilities.setFullSystemClasspathInSystemProperty("full.java.class.path");
    }

    public static String getArgumentSettingCode(String ... args) {
        String arguments = "[''";
        for (String arg : args) {
            arguments = arguments + ",'" + arg + "'";
        }
        arguments = arguments + "]";
        return "import sys;\nsys.argv=" + arguments + "\n";
    }

    public static void main(String[] args) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        JythonScriptExecutorUtils.executeScript("org/lsst/ccs/scripting/jython/sendingCommands.py", (OutputStream)out, new String[0]);
        System.out.println(out.toString());
    }
}

