package org.lsst.ccs.gconsole.plugins.trending;

import java.io.Serializable;
import java.util.ArrayList;
import org.freehep.application.Application;
import org.freehep.application.studio.Studio;
import org.freehep.jas.plugin.plotter.DefaultPage;
import org.freehep.jas.services.PlotRegion;
import org.freehep.jas.services.Plotter;

/**
 *
 * @author onoprien
 */
public class TrendingPanel extends DefaultPage {

// -- Fields : -----------------------------------------------------------------
    
    private final LsstTrendingPlugin plugin;
    
    private volatile long lastRefresh;

// -- Life cycle : -------------------------------------------------------------
    
    public TrendingPanel(LsstTrendingPlugin plugin, String title) {
        super(((Studio)Application.getApplication()), plugin.getPlotFactory(), title);
        this.plugin = plugin;
        createRegions(1, 1);
    }
    

// -- Getters & Setters : ------------------------------------------------------

    public long getLastRefresh() {
        return lastRefresh;
    }

    public void setLastRefresh(long lastRefresh) {
        this.lastRefresh = lastRefresh;
    }

    
// -- Responding to page events : ----------------------------------------------
    
    @Override
    public boolean close() {
        boolean out = super.close();
        if (out) {
            plugin.closePage(this);
        }
        return out;
    }
    
    
// -- Saving/Restoring : -------------------------------------------------------
    
    Descriptor save() {
        Descriptor desc = new Descriptor();
        desc.setTitle(title());
        desc.setRows(rows());
        desc.setColumns(columns());
        int n = numberOfRegions();
        ArrayList<TrendPlotter.Descriptor> plotterDescriptors = new ArrayList<>(n);
        for (int i=0; i<n; i++) {
            PlotRegion region = region(i);
            if (region != null) {
                Plotter plotter = region.currentPlot();
                if (plotter != null && plotter instanceof TrendPlotter) {
                    TrendPlotter.Descriptor plotterDescriptor = ((TrendPlotter)plotter).save();
                    if (plotterDescriptor != null) {
                        plotterDescriptors.add(plotterDescriptor);
                    }
                }
            }
        }
        desc.setPlotters(plotterDescriptors.toArray(new TrendPlotter.Descriptor[0]));
        return desc;
    }
    
    void restore(Descriptor desc) {
        int rows = desc.getRows();
        int columns = desc.getColumns();
        if (rows != 1 || columns != 1) {
            createRegions(columns, rows);
        }
        int i = 0;
        for (TrendPlotter.Descriptor plotterDescriptor : desc.getPlotters()) {
            TrendPlotter plotter = plugin.create();
            plugin.showPlotter(plotter, region(i++));
            plotter.restore(plotterDescriptor);
        }
    }
    
    static public class Descriptor implements Serializable {

        private String title;
        private int rows;
        private int columns;
        private TrendPlotter.Descriptor[] plotters;

        public TrendPlotter.Descriptor[] getPlotters() {
            return plotters;
        }

        public void setPlotters(TrendPlotter.Descriptor[] plotters) {
            this.plotters = plotters;
        }

        public TrendPlotter.Descriptor getPlotters(int index) {
            return this.plotters[index];
        }

        public void setPlotters(int index, TrendPlotter.Descriptor plotters) {
            this.plotters[index] = plotters;
        }

        public int getColumns() {
            return columns;
        }

        public void setColumns(int columns) {
            this.columns = columns;
        }

        public int getRows() {
            return rows;
        }

        public void setRows(int rows) {
            this.rows = rows;
        }

        public String getTitle() {
            return title;
        }

        public void setTitle(String title) {
            this.title = title;
        }
        
    }
    
}
