package org.lsst.ccs.gconsole.plugins.tracer;

import java.awt.Color;
import java.io.PrintWriter;
import java.util.*;
import javax.swing.text.DefaultCaret;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.freehep.jas.plugin.console.Console;
import org.lsst.ccs.gconsole.plugins.alert.AlertService;

/**
 * Handles printing and additional communications between tracers and console services.
 * This is expected to be a temporary class that contains all console implementation dependent
 * tracer functionality. Once the console service is re-written, this bridge might no longer be necessary.
 *
 * @author onoprien
 */
public class TracerWriter {

// -- Fields : -----------------------------------------------------------------
    
    private final Console console;
    private final PrintWriter defaultWriter;
    private Map<Color, PrintWriter> writers;

// -- Construction and initialization : ----------------------------------------
    
    TracerWriter(Console console) {
        this.console = console;
        defaultWriter = new PrintWriter(console.getOutputStream(null), true);
    }
    
// -- Operations : -------------------------------------------------------------
    
    public void println(Object object) {
        defaultWriter.println(object);
    }
    
    public void println(FilteredMessage filteredMessage) {
        
        String text = filteredMessage.getMessage();
        if (text == null) text = filteredMessage.getBusMessage().toString();
        
        Color color = filteredMessage.getColor();
        if (color == null) {
            defaultWriter.println(text);
        } else {
            if (writers == null) writers = new HashMap<>(4);
            PrintWriter writer = writers.get(color);
            if (writer == null) {
                SimpleAttributeSet style = new SimpleAttributeSet();
                style.addAttribute(StyleConstants.Foreground, color);
                writer = new PrintWriter(console.getOutputStream(style), true);
                writers.putIfAbsent(color, writer);
            }
            writer.println(text);
        }
        
//        EnumSet<FilteredMessage.Flag> flags = filteredMessage.getFlags();
//        if (flags != null) {
//            flags.forEach(flag -> {
//                switch (flag) {
//                    
//                    /*
//                    PAUSE and RESUME do not work with current jas3 console since it uses 
//                    explicit scroll pane positioning.
//                    */
//                    
////                    case PAUSE:
////                        try {
////                            DefaultCaret caret = (DefaultCaret) console.getCaret();
////                            caret.setUpdatePolicy(DefaultCaret.NEVER_UPDATE);
////                        } catch (ClassCastException x) {
////                        }
////                        break;
//                    
////                    case RESUME:
////                        try {
////                            DefaultCaret caret = (DefaultCaret) console.getCaret();
////                            caret.setUpdatePolicy(DefaultCaret.UPDATE_WHEN_ON_EDT);
////                        } catch (ClassCastException x) {
////                        }
////                        break;
//                        
//                    case ATTENTION:
//                        console.getToolkit().beep();
//                        break;
//                }
//            });
//        }

    }
    
    public void reset() {
        writers = null;
        DefaultCaret caret = (DefaultCaret) console.getCaret();
        caret.setUpdatePolicy(DefaultCaret.UPDATE_WHEN_ON_EDT);
    }
    
}
