/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.trending;

import com.sun.jersey.api.client.WebResource;
import java.awt.Component;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.freehep.jas.plugin.tree.DefaultFTreeNodeAdapter;
import org.freehep.jas.plugin.tree.FTreeNode;
import org.freehep.jas.plugin.tree.FTreeNodeTransferable;
import org.freehep.jas.services.PlotRegionDropHandler;
import org.freehep.jas.services.Plotter;
import org.freehep.util.commanddispatcher.CommandProcessor;
import org.freehep.util.commanddispatcher.CommandSource;
import org.freehep.util.commanddispatcher.CommandSourceAdapter;
import org.lsst.ccs.gconsole.plugins.trending.ChannelDropHandler;
import org.lsst.ccs.gconsole.plugins.trending.DataChannelHandler;
import org.lsst.ccs.gconsole.plugins.trending.LsstTrendingPlugin;

final class DataChannelTreeAdapter
extends DefaultFTreeNodeAdapter {
    private final LsstTrendingPlugin plugin;
    private final WebResource service;
    private final ChannelDropHandler dropHandler;
    private final Commands commands = new Commands();
    private final Plotter fakePlotter = new DummyPlotter();

    DataChannelTreeAdapter(LsstTrendingPlugin plugin, WebResource service) {
        super(100);
        this.plugin = plugin;
        this.service = service;
        this.dropHandler = new ChannelDropHandler(plugin);
    }

    public LsstTrendingPlugin getPlugin() {
        return this.plugin;
    }

    public WebResource getResource() {
        return this.service;
    }

    public CommandProcessor commandProcessor(FTreeNode[] selectedNodes) {
        this.commands.setSelectedNodes(selectedNodes);
        return this.commands;
    }

    public JPopupMenu modifyPopupMenu(FTreeNode[] nodes, JPopupMenu menu) {
        this.commands.setSelectedNodes(nodes);
        if (menu.getSubElements().length != 0) {
            menu.addSeparator();
        }
        JMenuItem item = new JMenuItem("Show");
        item.setToolTipText("Plot in the region previously used for this channel, if any, or on a new page.");
        this.plugin.getApplication().getCommandTargetManager().add((CommandSource)new CommandSourceAdapter((AbstractButton)item));
        menu.add(item);
        item = new JMenuItem("Plot");
        item.setToolTipText("Plot in the currently selected region.");
        this.plugin.getApplication().getCommandTargetManager().add((CommandSource)new CommandSourceAdapter((AbstractButton)item));
        menu.add(item);
        item = new JMenuItem("Overlay");
        item.setToolTipText("Overlay on the currently selected plot.");
        this.plugin.getApplication().getCommandTargetManager().add((CommandSource)new CommandSourceAdapter((AbstractButton)item));
        menu.add(item);
        item = new JMenuItem("Add");
        this.plugin.getApplication().getCommandTargetManager().add((CommandSource)new CommandSourceAdapter((AbstractButton)item));
        menu.add(item);
        item = new JMenuItem("New Plot");
        item.setToolTipText("Plot in a new region.");
        this.plugin.getApplication().getCommandTargetManager().add((CommandSource)new CommandSourceAdapter((AbstractButton)item));
        menu.add(item);
        item = new JMenuItem("New Page");
        item.setToolTipText("Plot on a new page.");
        this.plugin.getApplication().getCommandTargetManager().add((CommandSource)new CommandSourceAdapter((AbstractButton)item));
        menu.add(item);
        item = new JMenuItem("Refresh");
        item.setToolTipText("Refresh plots for this channel.");
        this.plugin.getApplication().getCommandTargetManager().add((CommandSource)new CommandSourceAdapter((AbstractButton)item));
        menu.add(item);
        menu.addSeparator();
        return menu;
    }

    public boolean doubleClick(FTreeNode node) {
        this.commands.setSelectedNodes(new FTreeNode[]{node});
        switch (this.plugin.getPreferences().doubleClick()) {
            case -1: {
                this.commands.onShow();
                break;
            }
            case -2: {
                this.commands.onPlot();
                break;
            }
            case -3: {
                this.commands.onNewPlot();
                break;
            }
            case -4: {
                this.commands.onNewPage();
                break;
            }
            default: {
                this.commands.onShow();
            }
        }
        return true;
    }

    public FTreeNodeTransferable modifyTransferable(FTreeNode[] nodes, FTreeNodeTransferable transferable) {
        transferable.addDataForClass(PlotRegionDropHandler.class, (Object)this.dropHandler);
        transferable.addDataForClass(Plotter.class, (Object)this.fakePlotter);
        return transferable;
    }

    public class DummyPlotter
    implements Plotter {
        public void plot(Object data, int mode) {
        }

        public void plot(Object data, int mode, Object style, String options) {
        }

        public void remove(Object data) {
        }

        public void clear() {
        }

        public Component viewable() {
            return null;
        }

        public List getData() {
            return null;
        }
    }

    public class Commands
    extends CommandProcessor {
        private volatile FTreeNode[] selectedNodes;

        void setSelectedNodes(FTreeNode[] selectedNodes) {
            this.selectedNodes = selectedNodes;
        }

        public void onShow() {
            DataChannelHandler chan = (DataChannelHandler)this.selectedNodes[0].objectForClass(DataChannelHandler.class);
            if (chan == null) {
                return;
            }
            DataChannelTreeAdapter.this.plugin.getPlotMaker().plot(chan, null, true, true, false, false);
        }

        public void onOverlay() {
            DataChannelHandler chan = (DataChannelHandler)this.selectedNodes[0].objectForClass(DataChannelHandler.class);
            if (chan == null) {
                return;
            }
            DataChannelTreeAdapter.this.plugin.getPlotMaker().plot(chan, null, false, false, false, true);
        }

        public void onNewPlot() {
            DataChannelHandler chan = (DataChannelHandler)this.selectedNodes[0].objectForClass(DataChannelHandler.class);
            if (chan == null) {
                return;
            }
            DataChannelTreeAdapter.this.plugin.getPlotMaker().plot(chan, null, false, false, true, false);
        }

        public void onPlot() {
            DataChannelHandler chan = (DataChannelHandler)this.selectedNodes[0].objectForClass(DataChannelHandler.class);
            if (chan == null) {
                return;
            }
            DataChannelTreeAdapter.this.plugin.getPlotMaker().plot(chan, null, false, false, false, false);
        }

        public void onNewPage() {
            DataChannelHandler chan = (DataChannelHandler)this.selectedNodes[0].objectForClass(DataChannelHandler.class);
            if (chan == null) {
                return;
            }
            DataChannelTreeAdapter.this.plugin.getPlotMaker().plot(chan, null, false, true, false, false);
        }

        public void onRefresh() {
            DataChannelHandler chan = (DataChannelHandler)this.selectedNodes[0].objectForClass(DataChannelHandler.class);
            if (chan == null) {
                return;
            }
            DataChannelTreeAdapter.this.plugin.getPlotMaker().refresh(chan, null);
        }
    }
}

