/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.tracer;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.freehep.application.mdi.PageListener;
import org.freehep.jas.plugin.console.Console;
import org.freehep.jas.plugin.console.ConsoleService;
import org.freehep.swing.popup.HasPopupItems;
import org.lsst.ccs.gconsole.ConsolePlugin;
import org.lsst.ccs.gconsole.Plugin;
import org.lsst.ccs.gconsole.plugins.tracer.FilterRegistry;
import org.lsst.ccs.gconsole.plugins.tracer.MessageFilter;
import org.lsst.ccs.gconsole.plugins.tracer.Tracer;
import org.lsst.ccs.gconsole.plugins.tracer.TracerWriter;

@Plugin(name="LSST Tracer Plugin", description="LSST CCS alert notification service.")
public class LsstTracerPlugin
extends ConsolePlugin {
    private final String defaultTracerName = "LSST Tracer";
    private final FilterRegistry filterRegistry = new FilterRegistry(this);
    private final Action newTracerAction = new AbstractAction("LSST Tracer"){

        @Override
        public void actionPerformed(ActionEvent e) {
            LsstTracerPlugin.this.createTracer("LSST Tracer");
        }
    };

    @Override
    public void initialize() {
        this.getConsole().getLookup().add((Object)this);
        this.getServices().addMenu(this.newTracerAction, "File", "New:-1:1");
    }

    @Override
    public void start() {
        this.filterRegistry.init();
    }

    public FilterRegistry getFilterRegistry() {
        return this.filterRegistry;
    }

    public Tracer createTracer(String name) {
        return this.createTracer(name, (MessageFilter)null);
    }

    public Tracer createTracer(String name, String filterName) {
        return this.createTracer(name, this.filterRegistry.getFilter(filterName));
    }

    public Tracer createTracer(String name, MessageFilter filter) {
        ConsoleService cs = (ConsoleService)this.getConsole().getLookup().lookup(ConsoleService.class);
        Tracer tracer = null;
        if (cs != null) {
            tracer = new Tracer(this, filter);
            Console console = cs.createConsole(name, null, (HasPopupItems)tracer);
            TracerWriter pw = new TracerWriter(console);
            cs.getPageContextForConsole(console).addPageListener((PageListener)tracer);
            tracer.start(pw);
        }
        return tracer;
    }
}

