/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.plots;

import hep.aida.IManagedObject;
import hep.aida.ref.tree.Tree;
import hep.aida.util.XMLUtils;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.SwingUtilities;
import org.freehep.application.studio.Studio;
import org.freehep.jas.extension.aida.AIDAPlugin;
import org.freehep.jas.plugin.tree.FTree;
import org.freehep.jas.plugin.tree.FTreeNode;
import org.freehep.jas.plugin.tree.FTreeNodeAddedNotification;
import org.freehep.jas.plugin.tree.FTreeNodeRemovedNotification;
import org.freehep.jas.plugin.tree.FTreeNotification;
import org.freehep.jas.plugin.tree.FTreePath;
import org.freehep.jas.plugin.tree.FTreeProvider;
import org.freehep.jas.services.PlotFactory;
import org.freehep.util.FreeHEPLookup;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusSubsystemData;
import org.lsst.ccs.messaging.StatusMessageListener;

class PlotsListener
implements StatusMessageListener {
    private final FreeHEPLookup lookup;
    private final Studio studio;
    private final PlotFactory plotFactory;
    private final FTreeProvider treeProvider;
    private final FTree tree;
    private final Tree masterTree;

    public PlotsListener(Studio studio) {
        this.studio = studio;
        this.lookup = studio.getLookup();
        this.plotFactory = (PlotFactory)this.lookup.lookup(PlotFactory.class);
        this.treeProvider = (FTreeProvider)this.lookup.lookup(FTreeProvider.class);
        this.tree = this.treeProvider.tree();
        this.masterTree = ((AIDAPlugin)this.lookup.lookup(AIDAPlugin.class)).aidaMasterTree();
    }

    public void onStatusMessage(StatusMessage msg) {
        StatusSubsystemData plotsMsg = (StatusSubsystemData)msg;
        String source = msg.getOriginAgentInfo().getName();
        List plots = plotsMsg.getEncodedData().getListOfKeyValueData(KeyValueData.KeyValueDataType.KeyValuePlotData);
        if (this.tree != null) {
            for (KeyValueData d : plots) {
                String plot = (String)((Object)d.getValue());
                String key = d.getKey();
                String plotPath = source;
                if (!key.isEmpty()) {
                    plotPath = plotPath + "/" + key;
                    plotPath = plotPath.replace("//", "/");
                }
                String dirPath = plotPath.substring(0, plotPath.lastIndexOf("/"));
                String plotName = plotPath.substring(plotPath.lastIndexOf("/") + 1);
                try {
                    this.masterTree.find(dirPath);
                }
                catch (IllegalArgumentException e) {
                    this.masterTree.mkdirs(dirPath);
                }
                StringTokenizer st = new StringTokenizer(dirPath, "/");
                String[] treePath = new String[st.countTokens() + 1];
                int count = 0;
                while (st.hasMoreTokens()) {
                    treePath[count++] = st.nextToken();
                }
                treePath[count] = plotName;
                final FTreePath path = new FTreePath(treePath);
                FTreeNode node = this.tree.findNode(path);
                try {
                    final IManagedObject obj = XMLUtils.createManagedObject((String)plot);
                    final boolean removeNode = node != null;
                    try {
                        SwingUtilities.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                if (removeNode) {
                                    PlotsListener.this.tree.treeChanged((FTreeNotification)new FTreeNodeRemovedNotification((Object)PlotsListener.this.studio, path));
                                }
                                PlotsListener.this.tree.treeChanged((FTreeNotification)new FTreeNodeAddedNotification((Object)PlotsListener.this.studio, path, (Object)obj));
                            }
                        });
                    }
                    catch (InterruptedException ie) {
                        throw new RuntimeException(ie);
                    }
                    catch (InvocationTargetException ex) {
                        throw new RuntimeException(ex);
                    }
                }
                catch (IOException ioe) {
                    throw new RuntimeException("Could not create IManagedObject", ioe);
                }
            }
        }
    }
}

