/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.console;

import java.awt.event.ActionEvent;
import java.io.IOException;
import javax.swing.AbstractAction;
import jline.console.ConsoleReader;
import org.freehep.jas.extensions.jconsole.JConsoleProvider;
import org.freehep.jas.extensions.jconsole.JConsoleService;
import org.freehep.jas.extensions.jconsole.JLineConsole;
import org.freehep.jas.extensions.jconsole.JLineConsoleProvider;
import org.lsst.ccs.gconsole.ConsolePlugin;
import org.lsst.ccs.gconsole.Plugin;
import org.lsst.ccs.messaging.AgentMessagingLayer;
import org.lsst.ccs.shell.JLineShell;
import org.lsst.ccs.subsystem.shell.ConsoleCommandShell;

@Plugin(name="LSST Console Plugin", description="LSST command console plugin.")
public class LsstConsolePlugin
extends ConsolePlugin {
    private final String defaultConsoleName = "LSST Console";

    @Override
    public synchronized void initialize() {
        this.getConsole().getLookup().add((Object)this);
        AbstractAction newConsoleAction = new AbstractAction("LSST Console"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LsstConsolePlugin.this.createCommandConsole("LSST Console");
            }
        };
        this.getServices().addMenu(newConsoleAction, "File", "New:-1:4");
    }

    @Override
    public synchronized void start() {
        JConsoleService cs = (JConsoleService)this.getConsole().getLookup().lookup(JConsoleService.class);
        if (cs == null) {
            throw new IllegalStateException("JConsole service is not available");
        }
        cs.addConsoleProvider(JLineConsole.class, (JConsoleProvider)new JLineConsoleProvider());
    }

    private synchronized JLineConsole createCommandConsole(String name) {
        try {
            JConsoleService cs = (JConsoleService)this.getConsole().getLookup().lookup(JConsoleService.class);
            if (cs != null) {
                JLineConsole console = (JLineConsole)cs.createConsole(JLineConsole.class, name, null, null);
                final JLineShell shell = ConsoleCommandShell.createJLineShell((AgentMessagingLayer)this.getConsole().getMessagingAccess(), (ConsoleReader)console.getConsoleReader());
                Thread t = new Thread("ConsoleInput-" + name){

                    @Override
                    public void run() {
                        try {
                            shell.run();
                        }
                        catch (IOException x) {
                            LsstConsolePlugin.this.getConsole().error("Error in command shell", x);
                        }
                    }
                };
                t.start();
                return console;
            }
        }
        catch (Exception x) {
            this.getConsole().error("Failed to start Console: " + name, x);
        }
        return null;
    }
}

