/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.jas3;

import java.awt.Dimension;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.freehep.jas.services.PreferencesTopic;
import org.lsst.ccs.gconsole.Console;
import org.lsst.ccs.gconsole.jas3.PropertyHandler;

public class PreferencePage
implements PreferencesTopic {
    private final Console console;
    private final String[] path;
    private final ArrayList<Setter> setters = new ArrayList(1);

    public PreferencePage(Console console, String[] path) {
        this.console = console;
        this.path = path;
    }

    public synchronized void add(String group, String format) {
        this.setters.add(new Setter(group, format));
        this.setters.trimToSize();
    }

    public String[] path() {
        return this.path;
    }

    public synchronized JComponent component() {
        try {
            return new GUI();
        }
        catch (IllegalArgumentException x) {
            return new JLabel("  " + x.getMessage() + "  ");
        }
    }

    public boolean apply(JComponent panel) {
        try {
            return ((GUI)panel).apply();
        }
        catch (ClassCastException x) {
            return true;
        }
    }

    public static void main(String ... args) {
        Pattern p = Pattern.compile("\\$\\{[^{}]+\\}");
        Matcher m = p.matcher("pre1${par1}pre2${par2}post");
        while (m.find()) {
            System.out.println("start " + m.start() + " end " + m.end() + " group " + m.group() + " count " + m.groupCount());
        }
        System.out.println(m.appendTail(new StringBuffer()));
    }

    private static class EnumData
    extends PropertyData {
        final JComboBox combo;

        EnumData(Object value) {
            Enum enumValue = (Enum)value;
            enumValue.getDeclaringClass().getEnumConstants();
            this.combo = new JComboBox(enumValue.getDeclaringClass().getEnumConstants());
            this.combo.setSelectedItem(enumValue);
            this.combo.setMaximumSize(this.combo.getPreferredSize());
        }

        @Override
        Object getValue() {
            return this.combo.getSelectedItem();
        }

        @Override
        JComponent getComponent() {
            return this.combo;
        }
    }

    private static class DoubleData
    extends PropertyData {
        final JTextField textField;

        DoubleData(Object value) {
            this.textField = new JTextField(value.toString(), 12);
            this.textField.setMaximumSize(this.textField.getPreferredSize());
        }

        @Override
        Object getValue() {
            return Double.valueOf(this.textField.getText());
        }

        @Override
        JComponent getComponent() {
            return this.textField;
        }
    }

    private static class LongData
    extends PropertyData {
        final JTextField textField;

        LongData(Object value) {
            this.textField = new JTextField(value.toString(), 20);
            this.textField.setMaximumSize(this.textField.getPreferredSize());
        }

        @Override
        Object getValue() {
            return Long.valueOf(this.textField.getText());
        }

        @Override
        JComponent getComponent() {
            return this.textField;
        }
    }

    private static class IntegerData
    extends PropertyData {
        final JTextField textField;

        IntegerData(Object value) {
            this.textField = new JTextField(value.toString(), 11);
            this.textField.setMaximumSize(this.textField.getPreferredSize());
        }

        @Override
        Object getValue() {
            return Integer.valueOf(this.textField.getText());
        }

        @Override
        JComponent getComponent() {
            return this.textField;
        }
    }

    private static class StringData
    extends PropertyData {
        final JTextField textField;

        StringData(Object value) {
            this.textField = new JTextField(value.toString());
            this.textField.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.textField.getPreferredSize().height));
        }

        @Override
        String getValue() {
            return this.textField.getText();
        }

        @Override
        JComponent getComponent() {
            return this.textField;
        }
    }

    private static class BooleanData
    extends PropertyData {
        final JCheckBox checkBox = new JCheckBox();

        BooleanData(Object value) {
            this.checkBox.setSelected((Boolean)value);
        }

        @Override
        Object getValue() {
            return this.checkBox.isSelected();
        }

        @Override
        JComponent getComponent() {
            return this.checkBox;
        }
    }

    private static abstract class PropertyData {
        private PropertyData() {
        }

        static PropertyData create(Object value) {
            switch (PropertyHandler.getType(value)) {
                case BOOLEAN: {
                    return new BooleanData(value);
                }
                case INTEGER: {
                    return new IntegerData(value);
                }
                case LONG: {
                    return new LongData(value);
                }
                case DOUBLE: {
                    return new DoubleData(value);
                }
                case STRING: {
                    return new StringData(value);
                }
                case ENUM: {
                    return new EnumData(value);
                }
            }
            throw new AssertionError((Object)("Unknown property type: " + (Object)((Object)PropertyHandler.getType(value))));
        }

        abstract Object getValue();

        abstract JComponent getComponent();
    }

    private class Setter {
        String group;
        String format;

        Setter(String group, String format) {
            this.group = group;
            this.format = format;
        }
    }

    private class GUI
    extends Box {
        private final int HSPACE = 10;
        private final int VSPACE = 5;
        private final Pattern ptrn;
        private final HashMap<String, PropertyData> data;

        GUI() {
            super(1);
            this.HSPACE = 10;
            this.VSPACE = 5;
            this.ptrn = Pattern.compile("\\$\\{[^}]+\\}");
            this.data = new HashMap();
            this.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
            HashMap<String, Box> groups = new HashMap<String, Box>();
            for (Setter setter : PreferencePage.this.setters) {
                String s;
                Box line = Box.createHorizontalBox();
                if (setter.group == null) {
                    this.add(line);
                    this.add(Box.createRigidArea(new Dimension(0, 5)));
                } else {
                    Box groupBox = (Box)groups.get(setter.group);
                    if (groupBox == null) {
                        groupBox = Box.createVerticalBox();
                        groupBox.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(setter.group), BorderFactory.createEmptyBorder(5, 10, 5, 10)));
                        groups.put(setter.group, groupBox);
                        this.add(Box.createRigidArea(new Dimension(0, 5)));
                        this.add(groupBox);
                        this.add(Box.createRigidArea(new Dimension(0, 5)));
                    }
                    groupBox.add(line);
                    groupBox.add(Box.createRigidArea(new Dimension(0, 5)));
                }
                Matcher mat = this.ptrn.matcher(setter.format);
                int i = 0;
                while (mat.find()) {
                    s = setter.format.substring(i, mat.start());
                    if (!s.isEmpty()) {
                        line.add(new JLabel(s));
                        line.add(Box.createRigidArea(new Dimension(10, 0)));
                    }
                    i = mat.end();
                    String key = setter.format.substring(mat.start() + 2, mat.end() - 1);
                    Object currentValue = PreferencePage.this.console.getProperty(key);
                    if (currentValue == null) {
                        throw new IllegalArgumentException("No such property: " + key);
                    }
                    PropertyData pd = PropertyData.create(currentValue);
                    line.add(pd.getComponent());
                    line.add(Box.createRigidArea(new Dimension(10, 0)));
                    PropertyData old = this.data.put(key, pd);
                    if (old == null) continue;
                    throw new IllegalArgumentException("Multiple setters for property: " + key);
                }
                s = setter.format.substring(i, setter.format.length());
                if (!s.isEmpty()) {
                    line.add(new JLabel(s));
                    line.add(Box.createRigidArea(new Dimension(10, 0)));
                }
                line.add(Box.createHorizontalGlue());
            }
            this.add(Box.createVerticalGlue());
        }

        boolean apply() {
            try {
                Map<String, Object> newValues = this.data.entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> ((PropertyData)e.getValue()).getValue()));
                PreferencePage.this.console.setProperties(newValues);
                return true;
            }
            catch (IllegalArgumentException x) {
                return false;
            }
        }
    }
}

