package org.lsst.ccs.gconsole.plugins.tracer;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.freehep.jas.plugin.console.Console;
import org.freehep.jas.plugin.console.ConsoleService;
import org.lsst.ccs.gconsole.ConsolePlugin;
import org.lsst.ccs.gconsole.Plugin;

/**
 * Graphical console plugin that creates and manages Tracers.
 */
@Plugin(name="LSST Tracer Plugin",
        description="LSST CCS alert notification service.")
public class LsstTracerPlugin extends ConsolePlugin {
    
// -- Fields : -----------------------------------------------------------------

    private final String defaultTracerName = "LSST Tracer";
    private final FilterRegistry filterRegistry;
    private final Action newTracerAction;


// -- Life cycle : -------------------------------------------------------------
    
    public LsstTracerPlugin() {
        filterRegistry = new FilterRegistry(this);
        newTracerAction = new AbstractAction("LSST Tracer") {
            @Override
            public void actionPerformed(ActionEvent e) {
                createTracer(defaultTracerName);
            }
        };
    }
    
    @Override
    public void initialize() {
        getConsole().getLookup().add(this);
        getServices().addMenu(newTracerAction, "File", "New:-1:1");
    }

    @Override
    public void start() {
//        JConsoleService cs = (JConsoleService) getConsole().getLookup().lookup(JConsoleService.class);
//        if (cs == null) throw new IllegalStateException("JConsole service is not available");
//        cs.addConsoleProvider(JLineConsole.class, new JLineConsoleProvider());
        filterRegistry.init();
    }


// -- Getters : ----------------------------------------------------------------
    
    public FilterRegistry getFilterRegistry() {
        return filterRegistry;
    }
    
    
// -- Handling tracers : -------------------------------------------------------

    public Tracer createTracer(String name) {
        return createTracer(name, (MessageFilter)null);
    }

    public Tracer createTracer(String name, String filterName) {
        return createTracer(name, filterRegistry.getFilter(filterName));
    }

    public Tracer createTracer(String name, MessageFilter filter) {
        ConsoleService cs = (ConsoleService) getConsole().getLookup().lookup(ConsoleService.class);
        Tracer tracer = null;
        if (cs != null) {
            tracer = new Tracer(this, filter);
            Console console = cs.createConsole(name, null, tracer);
//            SimpleAttributeSet style = new SimpleAttributeSet();
//            ConsoleOutputStream out = console.getOutputStream(style);
//            PrintWriter pw = new PrintWriter(out, true);
            TracerWriter pw = new TracerWriter(console);
            cs.getPageContextForConsole(console).addPageListener(tracer);
            tracer.start(pw);
        }
        return tracer;
    }

//    /** Creates JLineConsole based tracer. Not used at the moment. */
//    private JLineConsole createJTracerConsole(String name) {
//        FreeHEPLookup lookup = getApplication().getLookup();
//        JConsoleService cs = (JConsoleService) lookup.lookup(JConsoleService.class);
//        if (cs != null) {
//            Tracer tracer = new Tracer(getMessagingAccess());
//            JLineConsole console = (JLineConsole) cs.createConsole(JLineConsole.class, name, null, tracer);
//            PrintWriter pw = new PrintWriter(console.getConsoleReader().getOutput(), true);
//            cs.getPageContextForConsole(console).addPageListener(tracer);
//            tracer.start(pw); // This returns immediately
//            return console;
//        }
//        return null;
//    }
    
}
