package org.lsst.ccs.gconsole.plugins.rest;

import javax.swing.JComponent;
import org.freehep.jas.services.PreferencesTopic;

/**
 * A JAS preferences topic, which allows the restful server location to be controlled
 * from the JAS preferences panel.
 * @author turri
 */
class RestPreferencesTopic implements PreferencesTopic {

    private final String[] restPreferencesPath = {"LSST","Servers","Rest"};
    private final RestPreferences prefs;
    
    RestPreferencesTopic(RestPreferences prefs) {
        this.prefs = prefs;
    }
    
    @Override
    public boolean apply(JComponent panel) {
        RestServerPreferencesPanel pp = (RestServerPreferencesPanel) panel;
        pp.apply();
        return true;
    }


    @Override
    public String[] path() {
        return restPreferencesPath;
    }

    @Override
    public JComponent component() {
        return new RestServerPreferencesPanel(prefs);
    } 
}
