package org.lsst.ccs.gconsole.plugins.dictionary;

import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.freehep.application.Application;
import org.freehep.application.mdi.PageEvent;
import org.freehep.application.studio.Studio;
import org.lsst.ccs.gconsole.ConsolePlugin;
import org.lsst.ccs.gconsole.Plugin;
import org.lsst.ccs.messaging.AgentMessagingLayer;


/**
 * LSST Dictionary Plugin.
 * @author Etienne
 */
@Plugin(name="LSST Dictionary Plugin",
        description="LSST Dictionary Plugin allows listing available commands for a subsystem and executing them.",
        shortDescription="LSST CCS Dictionary GUI")
public class LsstDictionaryPlugin extends ConsolePlugin {

    private final String defaultConsoleName = "Dictionary Interface";
    DictionaryBusMaster dictionaryBusMaster;
    private AgentMessagingLayer messagingAccess;

    @Override
    public void initialize() {
        getConsole().getLookup().add(this);
        Action newDictionaryAction = new AbstractAction("LSST Dictionary") {
            @Override
            public void actionPerformed(ActionEvent e) {
                createDictionaryDialog(defaultConsoleName);
            }
        };
        getServices().addMenu(newDictionaryAction, "File", "New:-1:3");
    }
    
    @Override
    public void start(){
        messagingAccess = getConsole().getMessagingAccess();
    }
    
    private void createDictionaryDialog(String name) {
        dictionaryBusMaster = new DictionaryBusMaster(messagingAccess);
        dictionaryBusMaster.initGUI();
        Studio studio = (Studio) Application.getApplication();
        studio.getPageManager().openPage(dictionaryBusMaster.getMainPane(), name, null);
        studio.getPageManager().addPageListener(event -> {
            if (event.getID() == PageEvent.PAGECLOSED){ // tab closed
                Component c = event.getPageContext().getPage();
                if (c.equals(dictionaryBusMaster.getMainPane())){
                    dictionaryBusMaster.doShutdown();
                }
            }
        });
    }
    
}
