package org.lsst.ccs.gconsole.jas3;

import java.awt.Window;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.freehep.application.Application;
import org.freehep.application.studio.Studio;
import org.freehep.util.FreeHEPLookup;
import org.lsst.ccs.gconsole.Console;

/**
 * Jas3-based Graphical Console implementation.
 * 
 * @author onoprien
 */
public class Jas3Console extends Console {
    
// -- Fields : -----------------------------------------------------------------
    
    private final PropertyHandler prop;
    private final HashMap<String,PreferencePage> prefs = new HashMap<>();
    
    
// -- Life cycle : -------------------------------------------------------------
    
    public Jas3Console() {
        prop = new PropertyHandler(getApplication().getUserProperties());
    }
    
    
// -- Getters : ----------------------------------------------------------------
    
    @Override
    public FreeHEPLookup getLookup() {
        return getApplication().getLookup();
    }

    @Override
    public Window getWindow() {
        return SwingUtilities.getWindowAncestor(Application.getApplication());
    }
    
    public final Studio getApplication() {
        return (Studio) Application.getApplication();
    }
    
    
// -- Error reporting : --------------------------------------------------------
    
    @Override
    public void error(String message) {
        getApplication().error(message);
    }
    
    @Override
    public void error(String message, Exception x) {
        getApplication().error(message, x);
    }
    
    
// -- Handling properties : ----------------------------------------------------

    @Override
    public void addProperty(String key, Object defaultValue) {
        prop.addProperty(key, defaultValue);
    }
    
    @Override
    public Object removeProperty(String key) {
        return prop.removeProperty(key);
    }

    @Override
    public void addPreference(String[] path, String group, String format) {
        PreferencePage page;
        synchronized (prefs) {
            page = prefs.get(Arrays.toString(path));
            if (page == null) {
                page = new PreferencePage(this, path);
                prefs.put(Arrays.toString(path), page);
                getLookup().add(page);
            }
            page.add(group, format);
        }
    }

    @Override
    public Object getProperty(String key) {
        return prop.getProperty(key);
    }

    @Override
    public Object setProperty(String key, Object value) {
        return prop.setProperty(key, value);
    }
   
    @Override
    public void setProperties(Map<String,Object> properties) {
        prop.setProperties(properties);
    }
    
    @Override
    public void addPropertyListener(PropertyListener listener, String filter) {
        prop.addPropertyListener(listener, filter);
    }
    
    @Override
    public boolean removePropertyListener(PropertyListener listener) {
        return prop.removePropertyListener(listener);
    }

}
