/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.jas.plugin.plotter;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import org.freehep.jas.plugin.plotter.DefaultPlotRegionDropHandler;
import org.freehep.jas.plugin.plotter.RegionBorder;
import org.freehep.jas.services.PlotFactory;
import org.freehep.jas.services.PlotRegion;
import org.freehep.jas.services.PlotRegionDropHandler;
import org.freehep.jas.services.Plotter;
import org.freehep.swing.popup.HasPopupItems;

public class DefaultRegion
extends JPanel
implements PlotRegion,
DropTargetListener,
HasPopupItems {
    private final RegionBorder border = new RegionBorder();
    private final PlotFactory factory;
    private final PlotRegionDropHandler defaultDropHandler;
    private static final Color activeBorderColor = Color.red;
    private static final Color defaultBorderColor = Color.green;
    private static final Color selectedBorderColor = Color.blue;
    private Plotter plotter;
    private boolean selected = false;
    private ArrayList<HasPopupItems> popup;

    DefaultRegion(PlotFactory factory) {
        super(new BorderLayout());
        this.factory = factory;
        this.setBorder(this.border);
        this.border.setColor(defaultBorderColor);
        this.defaultDropHandler = new DefaultPlotRegionDropHandler(this, factory);
        this.setOpaque(false);
        DropTarget dt = new DropTarget(this, this);
    }

    void setSelected(boolean selected) {
        this.selected = selected;
        this.border.setColor(selected ? selectedBorderColor : defaultBorderColor);
        this.repaint();
    }

    @Override
    public void showPlot(Plotter plotter) {
        this.removeAll();
        this.plotter = plotter;
        this.add(plotter.viewable(), "Center");
        this.revalidate();
        this.repaint();
    }

    @Override
    public void clear() {
        if (this.plotter != null) {
            this.plotter.clear();
            this.plotter = null;
        }
        this.removeAll();
        this.revalidate();
        this.repaint();
    }

    @Override
    public Plotter currentPlot() {
        return this.plotter;
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
        if (this.acceptOrReject(dtde)) {
            this.border.setColor(activeBorderColor);
            this.repaint();
        }
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
        this.border.setColor(this.selected ? selectedBorderColor : defaultBorderColor);
        this.repaint();
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        this.border.setColor(defaultBorderColor);
        this.repaint();
        this.factory.currentPage().setCurrentRegion(this);
        try {
            PlotRegionDropHandler dh = this.getPlotRegionDropHandler(dtde);
            if (dh == null) {
                this.defaultDropHandler.drop(dtde);
            } else {
                dh.setPlotRegion(this);
                dh.drop(dtde);
            }
        }
        catch (Throwable x) {
            x.printStackTrace();
            dtde.dropComplete(false);
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    public PlotRegionDropHandler getPlotRegionDropHandler(DropTargetDropEvent dtde) {
        PlotRegionDropHandler dh = null;
        try {
            Transferable t = dtde.getTransferable();
            DataFlavor[] flavors = t.getTransferDataFlavors();
            for (int i = 0; i < flavors.length; ++i) {
                Class<?> k = flavors[i].getRepresentationClass();
                if (!PlotRegionDropHandler.class.isAssignableFrom(k)) continue;
                dh = (PlotRegionDropHandler)t.getTransferData(flavors[i]);
                break;
            }
        }
        catch (Throwable x) {
            x.printStackTrace();
            dtde.dropComplete(false);
        }
        return dh;
    }

    boolean acceptOrReject(DropTargetDragEvent e) {
        boolean accept = false;
        DataFlavor[] flavors = e.getCurrentDataFlavors();
        for (int i = 0; i < flavors.length; ++i) {
            Class<?> k = flavors[i].getRepresentationClass();
            boolean bl = accept = Plotter.class.isAssignableFrom(k) || this.factory.canCreatePlotterFor(k);
            if (accept) break;
        }
        if (accept) {
            e.acceptDrag(0x40000000);
        } else {
            e.rejectDrag();
        }
        return accept;
    }

    public JPopupMenu modifyPopupMenu(JPopupMenu menu, Component source, Point p) {
        JMenuItem item = new JMenuItem("Clear Region");
        item.setActionCommand("clear");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if ("clear".equals(actionEvent.getActionCommand())) {
                    DefaultRegion.this.clear();
                }
            }
        });
        menu.add(item);
        if (this.popup != null) {
            for (HasPopupItems it : this.popup) {
                menu = it.modifyPopupMenu(menu, source, p);
            }
        }
        return menu;
    }

    public boolean addPopupItems(HasPopupItems items) {
        if (this.popup == null) {
            this.popup = new ArrayList(1);
        }
        return this.popup.add(items);
    }

    public boolean removePopupItems(HasPopupItems items, Predicate<HasPopupItems> filter) {
        if (this.popup == null || this.popup.isEmpty()) {
            return false;
        }
        if (items == null) {
            if (filter == null) {
                this.popup.clear();
                return true;
            }
            Iterator<HasPopupItems> it = this.popup.iterator();
            boolean out = false;
            while (it.hasNext()) {
                if (!filter.test(it.next())) continue;
                it.remove();
                out = true;
            }
            return out;
        }
        if (filter == null || filter.test(items)) {
            return this.popup.remove(items);
        }
        return false;
    }

    @Override
    protected void printBorder(Graphics g) {
    }

    public static interface Predicate<T> {
        public boolean test(T var1);
    }
}

