/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.jas3;

import java.awt.Component;
import java.awt.Window;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.freehep.application.Application;
import org.freehep.application.studio.Studio;
import org.freehep.util.FreeHEPLookup;
import org.lsst.ccs.gconsole.Console;
import org.lsst.ccs.gconsole.jas3.PreferencePage;
import org.lsst.ccs.gconsole.jas3.PropertyHandler;

public class Jas3Console
extends Console {
    private final PropertyHandler prop;
    private final HashMap<String, PreferencePage> prefs = new HashMap();

    public Jas3Console() {
        this.prop = new PropertyHandler(this.getApplication().getUserProperties());
    }

    @Override
    public FreeHEPLookup getLookup() {
        return this.getApplication().getLookup();
    }

    @Override
    public Window getWindow() {
        return SwingUtilities.getWindowAncestor((Component)Application.getApplication());
    }

    public final Studio getApplication() {
        return (Studio)Application.getApplication();
    }

    @Override
    public void error(String message) {
        this.getApplication().error(message);
    }

    @Override
    public void error(String message, Exception x) {
        this.getApplication().error(message, (Throwable)x);
    }

    @Override
    public void addProperty(String key, Object defaultValue) {
        this.prop.addProperty(key, defaultValue);
    }

    @Override
    public Object removeProperty(String key) {
        return this.prop.removeProperty(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPreference(String[] path, String group, String format) {
        HashMap<String, PreferencePage> hashMap = this.prefs;
        synchronized (hashMap) {
            PreferencePage page = this.prefs.get(Arrays.toString(path));
            if (page == null) {
                page = new PreferencePage(this, path);
                this.prefs.put(Arrays.toString(path), page);
                this.getLookup().add(page);
            }
            page.add(group, format);
        }
    }

    @Override
    public Object getProperty(String key) {
        return this.prop.getProperty(key);
    }

    @Override
    public Object setProperty(String key, Object value) {
        return this.prop.setProperty(key, value);
    }

    @Override
    public void setProperties(Map<String, Object> properties) {
        this.prop.setProperties(properties);
    }

    @Override
    public void addPropertyListener(Console.PropertyListener listener, String filter) {
        this.prop.addPropertyListener(listener, filter);
    }

    @Override
    public boolean removePropertyListener(Console.PropertyListener listener) {
        return this.prop.removePropertyListener(listener);
    }
}

