/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.swing.Action;
import org.lsst.ccs.gconsole.Console;
import org.lsst.ccs.gconsole.ConsolePlugin;
import org.lsst.ccs.gconsole.ConsolePluginDescriptor;

public abstract class ConsolePluginServices {
    private final ConsolePlugin plugin;
    private final ConsolePluginDescriptor descriptor;
    private final Console console;
    protected final String prefix;

    protected ConsolePluginServices(Console console, ConsolePlugin plugin, ConsolePluginDescriptor descriptor) {
        this.console = console;
        this.plugin = plugin;
        this.descriptor = descriptor;
        this.prefix = "lsst.plugin." + descriptor.getName() + ".";
        console.addPropertyListener(plugin, this.prefix.replace(".", "\\.") + ".+");
    }

    public Console getConsole() {
        return this.console;
    }

    public ConsolePlugin getPlugin() {
        return this.plugin;
    }

    public ConsolePluginDescriptor getDescriptor() {
        return this.descriptor;
    }

    public abstract void addMenu(Action var1, String ... var2);

    public void addProperty(String key, Object defaultValue) {
        this.getConsole().addProperty(this.translatePropertyKey(key), defaultValue);
    }

    public Object removeProperty(String key) {
        return this.getConsole().removeProperty(this.translatePropertyKey(key));
    }

    public void addPreference(String[] path, String group, String format) {
        StringBuffer sb = new StringBuffer();
        Matcher m = Pattern.compile("\\$\\{([^${}]+)\\}").matcher(format);
        while (m.find()) {
            m.appendReplacement(sb, "");
            sb.append("${").append(this.translatePropertyKey(m.group(1))).append("}");
        }
        m.appendTail(sb);
        format = sb.toString();
        this.getConsole().addPreference(path, group, format);
    }

    public Object getProperty(String key) {
        return this.getConsole().getProperty(this.translatePropertyKey(key));
    }

    public Object setProperty(String key, Object value) {
        return this.getConsole().setProperty(this.translatePropertyKey(key), value);
    }

    public void setProperties(Map<String, Object> properties) {
        properties = properties.entrySet().stream().collect(Collectors.toMap(e -> this.translatePropertyKey((String)e.getKey()), e -> e.getValue()));
        this.getConsole().setProperties(properties);
    }

    protected String translatePropertyKey(String key) {
        return this.prefix + key;
    }
}

