package org.lsst.ccs.gconsole.plugins.tracer;

import java.util.function.Predicate;
import org.lsst.ccs.bus.messages.BusMessage;

/**
 * Adapter for using Predicate<BusMessage> as {@link MessageFilter}.
 *
 * @author onoprien
 */
public class MessageFilterAdapter implements MessageFilter {

// -- Private parts : ----------------------------------------------------------
    
    private final String name;
    private final String description;
    private final Predicate<BusMessage> delegate;

// -- Construction and initialization : ----------------------------------------

    public MessageFilterAdapter(Predicate<BusMessage> filter) {
        this(null, null, filter);
    }

    public MessageFilterAdapter(String name, String description, Predicate<BusMessage> filter) {
        this.name = name;
        this.description = description;
        delegate = filter;
    }
    
// -- Implementing MessageFilter : ---------------------------------------------

    @Override
    public String getName() {
        return name;
    }

    @Override
    public String getDescription() {
        return description;
    }
    
    @Override
    public FilteredMessage test(FilteredMessage filteredMessage) {
        return delegate.test(filteredMessage.getBusMessage()) ? filteredMessage : null;
    }
    
    
}
