package org.lsst.ccs.gconsole.plugins.rest;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Properties;
import org.freehep.application.PropertyUtilities;
import org.freehep.application.studio.Studio;

/**
 * Encapsulates the user's rest preferences.
 *
 * @author turri
 */
class RestPreferences {

    public static final String SERVER_PROPERTY = "org.lsst.rest.server";
    public static final String PORT_PROPERTY = "org.lsst.rest.port";
    public static final String CONNECT_ON_STARTUP_PROPERTY = "org.lsst.rest.connectOnStartup";
    private String server;
    private int port;
    private boolean connectOnStartup;
    private String oldURL;
    private final Properties user;
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    RestPreferences(Studio studio) {
        user = studio.getUserProperties();
        server = user.getProperty(SERVER_PROPERTY, "localhost");
        port = PropertyUtilities.getInteger(user, PORT_PROPERTY, 8080);
        connectOnStartup = PropertyUtilities.getBoolean(user, CONNECT_ON_STARTUP_PROPERTY, true);
        oldURL = getRestURL();
    }

    int getRestPort() {
        return port;
    }

    String getRestServer() {
        return server;
    }

    boolean isConnectOnStartup() {
        return connectOnStartup;
    }

    void setRestPort(int port) {
        this.port = port;
        PropertyUtilities.setInteger(user, PORT_PROPERTY, port);
    }

    void setRestServer(String server) {
        this.server = server;
        user.setProperty(SERVER_PROPERTY, server);
    }

    void setConnectOnStartup(boolean connect) {
        PropertyUtilities.setBoolean(user, CONNECT_ON_STARTUP_PROPERTY, connect);
    }

    String getURLForServerAndPort(String server, int port) {
        return String.format("http://%s:%d/rest/data", server, port);
    }

    final String getRestURL() {
        return getURLForServerAndPort(getRestServer(), getRestPort());
    }

    void firePropertyChanged() {
        if (!getRestURL().equals(oldURL)) {
            pcs.firePropertyChange("value", oldURL, getRestURL());
            oldURL = getRestURL();
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        pcs.removePropertyChangeListener(listener);
    }
}
