package org.lsst.ccs.gconsole.plugins.rest;

import java.util.logging.Logger;
import org.freehep.application.studio.Studio;
import org.freehep.util.FreeHEPLookup;
import org.lsst.ccs.gconsole.jas3.LsstPlugin;

/**
 * This plugin deals with attaching to the restful interfaces, and fetching and 
 * displaying trending data.
 * 
 * @author tonyj
 */
public class LsstRestPlugin extends LsstPlugin {

    private static final Logger logger = Logger.getLogger(LsstRestPlugin.class.getName());
    private RestPreferences prefs;
    private Studio studio;
    private RestConnector connector;
    

    @Override
    protected void init() {
        logger.finest("LSSTRestPlugin created");
        studio = getApplication();        
        prefs = new RestPreferences(studio);
        
        FreeHEPLookup lookup = studio.getLookup();
        lookup.add(new RestPreferencesTopic(prefs));
    }

    @Override
    protected void postInit() {
        if (prefs.isConnectOnStartup()) {
            connector = new RestConnector(studio, prefs);
            Thread t = new Thread(connector);
            t.start();
        }
    }
    
    public void refreshConnector() {
        connector.propertyChange(null);
    }
}
